/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupPluginSettings
implements ActiveObjectsUpgradeTask {
    private final Logger log = LoggerFactory.getLogger(CleanupPluginSettings.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProjectManager projectManager;

    public CleanupPluginSettings(ProjectManager projectManager, PluginSettingsFactory pluginSettingsFactory) {
        this.projectManager = projectManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        this.log.debug("upgrade [ " + this.getModelVersion() + " ]");
        this.cleanupBitbucketRecords();
        this.cleanupGithubRecords();
    }

    private void cleanupBitbucketRecords() {
        List projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            String projectKey = project.getKey();
            List<String> repositoriesUrls = this.getBitbucketRepositories(projectKey);
            if (repositoriesUrls != null) {
                for (String repositoryUrl : repositoriesUrls) {
                    this.removeBitbucketIssueMappings(projectKey, repositoryUrl);
                    this.removeBitbucketCredentials(projectKey, repositoryUrl);
                }
            }
            this.removeBitbucketRepositories(projectKey);
        }
    }

    private List<String> getBitbucketRepositories(String projectKey) {
        List<String> repoUrls = (List<String>)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("bitbucketRepositoryURLArray");
        return repoUrls != null ? repoUrls : Collections.emptyList();
    }

    private void removeBitbucketRepositories(String projectKey) {
        this.log.debug(" === removing Bitbucket repositories for project [{}] === ", (Object)projectKey);
        this.pluginSettingsFactory.createSettingsForKey(projectKey).remove("githubRepositoryURLArray");
    }

    private void removeBitbucketIssueMappings(String projectKey, String repositoryUrl) {
        this.log.debug(" === removing issue mappings for Bitbucket repository {} === ", (Object)repositoryUrl);
        PluginSettings ps = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        ArrayList issueIds = (ArrayList)ps.get("bitbucketIssueIDs" + repositoryUrl);
        if (issueIds != null) {
            for (String issueId : issueIds) {
                ps.remove("bitbucketIssueCommitArray" + issueId);
            }
        }
    }

    private void removeBitbucketCredentials(String projectKey, String repositoryUrl) {
        this.log.debug(" === removing credentials for Bitbucket repository {} === ", (Object)repositoryUrl);
        PluginSettings ps = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        ps.remove("bitbucketUserName" + repositoryUrl);
        ps.remove("bitbucketPassword" + repositoryUrl);
    }

    private void cleanupGithubRecords() {
        List projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            String projectKey = project.getKey();
            List<String> repositoriesUrls = this.getGithubRepositories(projectKey);
            if (repositoriesUrls != null) {
                for (String repositoryUrl : repositoriesUrls) {
                    this.removeGithubIssueMappings(projectKey, repositoryUrl);
                }
            }
            this.removeGithubRepositories(projectKey);
        }
    }

    private List<String> getGithubRepositories(String projectKey) {
        List<String> repoUrls = (List<String>)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("githubRepositoryURLArray");
        return repoUrls != null ? repoUrls : Collections.emptyList();
    }

    private void removeGithubRepositories(String projectKey) {
        this.log.debug(" === removing GitHub repositories for project [{}] === ", (Object)projectKey);
        this.pluginSettingsFactory.createSettingsForKey(projectKey).remove("githubRepositoryURLArray");
    }

    private void removeGithubIssueMappings(String projectKey, String repositoryUrl) {
        this.log.debug(" === removing issue mappings for GitHub repository {} === ", (Object)repositoryUrl);
        PluginSettings ps = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        ArrayList issueIds = (ArrayList)ps.get("githubIssueIDs" + repositoryUrl);
        if (issueIds != null) {
            for (String issueId : issueIds) {
                ps.remove("githubIssueCommitArray" + issueId);
            }
        }
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"7");
    }
}

