/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.less.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.less.impl.DynamicLookAndFeelUtil;
import com.atlassian.jira.web.less.LookAndFeelLessProvider;
import com.atlassian.lesscss.spi.DimensionAwareUriResolver;
import com.atlassian.lesscss.spi.EncodeStateResult;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.PrebakeErrorFactory;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class DynamicLookAndFeelUriResolver
implements DimensionAwareUriResolver {
    private LookAndFeelLessProvider lessGenerator;

    @Autowired
    public DynamicLookAndFeelUriResolver(@ComponentImport WebResourceIntegration webResourceIntegration, @ComponentImport ApplicationProperties applicationProperties) {
        this.lessGenerator = new LookAndFeelLessProvider(applicationProperties, webResourceIntegration);
    }

    public boolean exists(URI uri) {
        return DynamicLookAndFeelUtil.isDynamicLookAndFeelURI(uri);
    }

    public EncodeStateResult encodeState(URI uri, Coordinate coordinate) {
        PrebakeError prebakeError = PrebakeErrorFactory.from((String)"Less resource makes use of JIRA Look & Feel properties");
        String encodedState = this.lessGenerator.encodeState();
        return new EncodeStateResult(encodedState, Optional.of(prebakeError));
    }

    public String encodeState(URI uri) {
        return this.lessGenerator.encodeState();
    }

    public InputStream open(URI uri) throws IOException {
        String less = this.lessGenerator.makeLookAndFeelLess();
        return new ByteArrayInputStream(less.getBytes(Charset.forName("UTF-8")));
    }

    public boolean supports(URI uri) {
        return DynamicLookAndFeelUtil.isDynamicLookAndFeelURI(uri);
    }

    public Dimensions computeDimensions() {
        return Dimensions.empty();
    }
}

