/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.core.hook;

import com.atlassian.jira.bc.workflow.WorkflowTransitionService;
import com.atlassian.jira.blueprint.api.ProjectCreateHookHelper;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.project.template.hook.ConfigureResponse;
import com.atlassian.jira.project.template.hook.EmptyAddProjectHook;
import com.atlassian.jira.projecttemplates.core.service.CoreProjectShortcutGenerator;
import com.atlassian.jira.workflow.JiraWorkflow;

public class TaskManagementProjectCreateHook
extends EmptyAddProjectHook {
    private static final String DONE_ACTION_NAME = "Done";
    private static final String REOPEN_ACTION_NAME = "Reopen";
    private static final String WORKFLOW_KEY = "WF1";
    private static final String NO_SCREEN = "no_screen";
    private final ProjectCreateHookHelper projectCreateHookHelper;
    private final WorkflowTransitionService workflowTransitionService;
    private final CoreProjectShortcutGenerator coreProjectShortcutGenerator;

    public TaskManagementProjectCreateHook(ProjectCreateHookHelper projectCreateHookHelper, WorkflowTransitionService workflowTransitionService, CoreProjectShortcutGenerator coreProjectShortcutGenerator) {
        this.projectCreateHookHelper = projectCreateHookHelper;
        this.workflowTransitionService = workflowTransitionService;
        this.coreProjectShortcutGenerator = coreProjectShortcutGenerator;
    }

    public ConfigureResponse configure(ConfigureData configureData) {
        ConfigureResponse response = ConfigureResponse.create();
        JiraWorkflow jiraWorkflow = (JiraWorkflow)configureData.createdWorkflows().get(WORKFLOW_KEY);
        if (jiraWorkflow == null) {
            throw new IllegalArgumentException("Workflow with key 'WF1' not found.");
        }
        this.projectCreateHookHelper.addResolutionValuePostFunction("", jiraWorkflow, REOPEN_ACTION_NAME);
        this.projectCreateHookHelper.addResolutionValuePostFunction("10000", jiraWorkflow, DONE_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, DONE_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, REOPEN_ACTION_NAME);
        FieldScreen resolveScreen = (FieldScreen)configureData.createdScreens().get(NO_SCREEN);
        this.workflowTransitionService.setScreen(DONE_ACTION_NAME, resolveScreen, jiraWorkflow);
        this.projectCreateHookHelper.applyWorkflowChanges(jiraWorkflow);
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.jira-core-task-management");
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.general");
        return response;
    }
}

