/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.core.hook;

import com.atlassian.jira.blueprint.api.ProjectCreateHookHelper;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.project.template.hook.ConfigureResponse;
import com.atlassian.jira.project.template.hook.EmptyAddProjectHook;
import com.atlassian.jira.projecttemplates.core.service.CoreProjectShortcutGenerator;
import com.atlassian.jira.workflow.JiraWorkflow;

public class ProcessManagementProjectCreateHook
extends EmptyAddProjectHook {
    private static final String DONE_ACTION_NAME = "Done";
    private static final String REOPEN_ACTION_NAME = "Reopen";
    private static final String REOPEN_START_PROGRESS_ACTION_NAME = "Reopen and start progress";
    private static final String WORKFLOW_KEY = "WF1";
    private final ProjectCreateHookHelper projectCreateHookHelper;
    private final CoreProjectShortcutGenerator coreProjectShortcutGenerator;

    public ProcessManagementProjectCreateHook(ProjectCreateHookHelper projectCreateHookHelper, CoreProjectShortcutGenerator coreProjectShortcutGenerator) {
        this.projectCreateHookHelper = projectCreateHookHelper;
        this.coreProjectShortcutGenerator = coreProjectShortcutGenerator;
    }

    public ConfigureResponse configure(ConfigureData configureData) {
        ConfigureResponse response = ConfigureResponse.create();
        JiraWorkflow jiraWorkflow = (JiraWorkflow)configureData.createdWorkflows().get(WORKFLOW_KEY);
        if (jiraWorkflow == null) {
            throw new IllegalArgumentException("Workflow with key 'WF1' not found.");
        }
        this.projectCreateHookHelper.addResolutionValuePostFunction("", jiraWorkflow, REOPEN_ACTION_NAME);
        this.projectCreateHookHelper.addResolutionValuePostFunction("", jiraWorkflow, REOPEN_START_PROGRESS_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, DONE_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, REOPEN_ACTION_NAME);
        this.projectCreateHookHelper.applyWorkflowChanges(jiraWorkflow);
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.jira-core-process-management");
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.general");
        return response;
    }
}

