/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.renderer;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import com.atlassian.jirafisheyeplugin.web.renderer.CrucibleRenderer;
import java.util.List;

public class WikiRendererBean {
    private static final String MESSAGE_RENDERER = "atlassian-wiki-renderer";
    private RendererManager rendererManager;
    private IssueManager issueManager;
    private final FishEyeConfig fishEyeConfig;
    private Issue issue = null;
    private Project project = null;

    public WikiRendererBean(RendererManager rendererManager, IssueManager issueManager, FishEyeConfig fishEyeConfig) {
        this.rendererManager = rendererManager;
        this.issueManager = issueManager;
        this.fishEyeConfig = fishEyeConfig;
    }

    protected void setIssue(Issue issue) {
        this.issue = issue;
    }

    protected void setProject(Project project) {
        this.project = project;
    }

    public String render(String text) {
        return this.render(text, false);
    }

    public String renderCru(String text) {
        return this.render(text, true);
    }

    public String render(String text, boolean linkCruKeys) {
        if (linkCruKeys) {
            text = CrucibleRenderer.linkCrucibleKeys(text, this.fishEyeConfig.getCrucibleProjectToUrlMappings());
        }
        IssueRenderContext renderContext = this.resolveContext(text);
        return this.rendererManager.getRenderedContent(MESSAGE_RENDERER, text, renderContext);
    }

    private IssueRenderContext resolveContext(String text) {
        IssueRenderContext renderContext = null;
        if (this.issue != null) {
            renderContext = new IssueRenderContext(this.issue);
        } else {
            String issueKey;
            MutableIssue rIssue;
            List<String> keys;
            List<String> list = keys = this.project != null ? this.resolveIssueKeys(text, this.project.getKey()) : this.resolveIssueKeys(text);
            if (!keys.isEmpty() && (rIssue = this.issueManager.getIssueObject(issueKey = keys.get(0))) != null) {
                renderContext = new IssueRenderContext((Issue)rIssue);
            }
        }
        return renderContext;
    }

    List<String> resolveIssueKeys(String text, String pKey) {
        return FishEyeUtil.getIssueKeysFromString(text, pKey);
    }

    List<String> resolveIssueKeys(String text) {
        return FishEyeUtil.getIssueKeysFromString(text);
    }
}

