/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.renderer;

import com.atlassian.core.util.map.EasyMap;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrucibleRenderer {
    public static final int HTML = 0;
    public static final int WIKI = 1;

    public static String linkCrucibleKeys(String body, String projectKey, String fisheyeUrl) {
        return CrucibleRenderer.linkCrucibleKeys(body, projectKey, fisheyeUrl, 1);
    }

    public static String linkCrucibleKeys(String body, String projectKey, String fisheyeUrl, int renderType) {
        return CrucibleRenderer.linkCrucibleKeys(body, EasyMap.build((Object)projectKey, (Object)fisheyeUrl), renderType);
    }

    public static String linkCrucibleKeys(String body, Set projectKeys, String fisheyeUrl) {
        return CrucibleRenderer.linkCrucibleKeys(body, projectKeys, fisheyeUrl, 1);
    }

    public static String linkCrucibleKeys(String body, Set projectKeys, String fisheyeUrl, int renderType) {
        HashMap keys2Urls = new HashMap();
        Iterator iterator = projectKeys.iterator();
        while (iterator.hasNext()) {
            keys2Urls.put(iterator.next(), fisheyeUrl);
        }
        return CrucibleRenderer.linkCrucibleKeys(body, keys2Urls, renderType);
    }

    public static String linkCrucibleKeys(String body, Map projectKeysToUrls) {
        return CrucibleRenderer.linkCrucibleKeys(body, projectKeysToUrls, 1);
    }

    public static String linkCrucibleKeys(String body, Map projectKeysToUrls, int renderType) {
        if (!TextUtils.stringSet((String)body)) {
            return "";
        }
        StringBuilder buff = new StringBuilder().append(body);
        String regex = "(^|[^a-zA-Z0-9-]|\\b)([a-zA-Z0-9-]+)(-[0-9]+)($|[^a-zA-Z0-9-]|\\b)";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(body);
        int offset = 0;
        while (m.find()) {
            String link;
            String projectKey = m.group(2);
            String reviewKey = projectKey + m.group(3);
            int start = m.start(2);
            int end = m.end(3);
            String baseUrl = (String)projectKeysToUrls.get(projectKey);
            if (baseUrl == null || CrucibleRenderer.isPartOfUrl(body, start) || CrucibleRenderer.isPartOfWikiUrl(body, start)) continue;
            switch (renderType) {
                case 0: {
                    link = CrucibleRenderer.renderAsHTMLLink(baseUrl, reviewKey);
                    break;
                }
                default: {
                    link = CrucibleRenderer.renderAsWikiLink(baseUrl, reviewKey);
                }
            }
            buff.replace(start + offset, end + offset, link);
            offset = offset - (end - start) + link.length();
        }
        return buff.toString();
    }

    protected static String renderAsWikiLink(String fisheyeUrl, String reviewKey) {
        return "[" + reviewKey + "|" + fisheyeUrl + "cru/" + reviewKey + "]";
    }

    protected static String renderAsHTMLLink(String fisheyeUrl, String reviewKey) {
        return "<a href=\"" + fisheyeUrl + "cru/" + reviewKey + "\">" + reviewKey + "</a>";
    }

    private static boolean isPartOfUrl(String body, int start) {
        int lastAnchorOpeningTag = body.substring(0, start).lastIndexOf("href=\"");
        if (lastAnchorOpeningTag == -1) {
            return false;
        }
        int closingTag = body.indexOf("</a>", lastAnchorOpeningTag);
        return lastAnchorOpeningTag < start && start < closingTag;
    }

    private static boolean isPartOfWikiUrl(String body, int start) {
        Pattern p = Pattern.compile("[^\\\\]\\[.*[^\\\\]|.*[^\\\\]\\]");
        Matcher m = p.matcher(body);
        while (m.find()) {
            if (m.start() >= start || m.end() <= start) continue;
            return true;
        }
        return false;
    }
}

