/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.projecttabpanel.fisheye;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSets;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.rest.eyeql.EyeQLQuery;
import com.atlassian.jirafisheyeplugin.rest.eyeql.WhereClauseFactory;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import com.atlassian.jirafisheyeplugin.web.ShowPanelHelper;
import com.atlassian.jirafisheyeplugin.web.charts.FishEyeChartManager;
import com.atlassian.jirafisheyeplugin.web.errorbeans.ErrorBeanUtils;
import com.atlassian.jirafisheyeplugin.web.projecttabpanel.AbstractFishEyeProjectTabPanel;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBeanFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.ListOrderedMap;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeProjectTabPanel
extends AbstractFishEyeProjectTabPanel
implements ProjectTabPanel {
    private static final Logger log = LoggerFactory.getLogger(FishEyeProjectTabPanel.class);
    private static final String MODE_STATISTICS = "statistics";
    private static final String MODE_CHANGESETS = "changesets";
    private static final String MODE_ALL = "all";
    private static final String MODE_CONFIGURE = "configure";
    private static final String FISHEYE_PROJECT_PANEL_MODE = "fisheye.project.panel.mode";
    private static final String PIE_SEGMENT_OTHER = "other";
    private static I18nHelper i18nBean = null;
    private final FishEyeManager fisheyeManager;
    private final ChangeSetManager changeSetManager;
    private final ReviewManager reviewManager;
    private final FishEyeChartManager chartManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final FishEyeConfig fisheyeConfig;
    private final WikiRendererBeanFactory wikiRendererBeanFactory;
    private final RepositoryPathStore repositoryPathStore;
    private final ShowPanelHelper showPanelHelper;
    private final ErrorBeanUtils errorBeanUtils;

    public FishEyeProjectTabPanel(FishEyeManager fishEyeManager, ChangeSetManager changeSetManager, ReviewManager reviewManager, FishEyeChartManager chartManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, WikiRendererBeanFactory wikiRendererBeanFactory, RepositoryPathStore repositoryPathStore, FishEyeConfig fisheyeConfig, WebResourceManager webResourceManager, ShowPanelHelper showPanelHelper, VelocityRequestContextFactory velocityRequestContextFactory, ErrorBeanUtils errorBeanUtils, SoftwareLicenseVerifier softwareLicenseVerifier) {
        super(authenticationContext, velocityRequestContextFactory, softwareLicenseVerifier, webResourceManager);
        this.fisheyeManager = fishEyeManager;
        this.changeSetManager = changeSetManager;
        this.reviewManager = reviewManager;
        this.chartManager = chartManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.wikiRendererBeanFactory = wikiRendererBeanFactory;
        this.repositoryPathStore = repositoryPathStore;
        this.fisheyeConfig = fisheyeConfig;
        this.showPanelHelper = showPanelHelper;
        this.errorBeanUtils = errorBeanUtils;
    }

    /*
     * Exception decompiling
     */
    public String getHtml(BrowseContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String calculateMode() {
        String mode = MODE_CHANGESETS;
        HttpServletRequest request = this.getRequest();
        HttpSession session = request.getSession();
        String parameter = request.getParameter("mode");
        if (parameter != null) {
            if (MODE_CHANGESETS.equals(parameter)) {
                mode = MODE_CHANGESETS;
                session.removeAttribute(FISHEYE_PROJECT_PANEL_MODE);
            } else if (MODE_STATISTICS.equals(parameter)) {
                mode = MODE_STATISTICS;
                session.setAttribute(FISHEYE_PROJECT_PANEL_MODE, (Object)MODE_STATISTICS);
            } else if (MODE_ALL.equals(parameter)) {
                mode = MODE_ALL;
                session.setAttribute(FISHEYE_PROJECT_PANEL_MODE, (Object)MODE_ALL);
            } else if (MODE_CONFIGURE.equals(parameter)) {
                mode = MODE_CONFIGURE;
                session.setAttribute(FISHEYE_PROJECT_PANEL_MODE, (Object)MODE_CONFIGURE);
            }
        } else if (session.getAttribute(FISHEYE_PROJECT_PANEL_MODE) != null) {
            mode = (String)session.getAttribute(FISHEYE_PROJECT_PANEL_MODE);
        }
        return mode;
    }

    protected void createHistoricalChangesetCharts(Project project, ChangeSets changesets, Map<String, Object> params, String singleRepositoryName, String fisheyeUrl) throws IOException {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(6, -90);
        Date then = cal.getTime();
        HashSet<Revision> revisions = new HashSet<Revision>();
        for (Changeset cs : changesets.getChangesets()) {
            if (cs.getDate().before(then)) continue;
            revisions.addAll(cs.getRevisions());
        }
        Map<String, Integer> historicalMap = this.initMapHistoricalMap(then, now);
        ListOrderedMap dayRevisions = new ListOrderedMap();
        dayRevisions.putAll(historicalMap);
        ListOrderedMap dayChangesets = new ListOrderedMap();
        dayChangesets.putAll(historicalMap);
        HashSet<String> talliedCSIds = new HashSet<String>();
        for (Revision revision : revisions) {
            String dateKey = this.toDateKey(revision.getDate());
            if (!talliedCSIds.contains(revision.getCsid())) {
                this.incMapValue((Map<String, Integer>)dayChangesets, dateKey);
                talliedCSIds.add(revision.getCsid());
            }
            if (!historicalMap.containsKey(dateKey) && !revision.getDate().after(now)) continue;
            this.incMapValue((Map<String, Integer>)dayRevisions, dateKey);
        }
        CategoryURLGenerator revUrlGenerator = null;
        CategoryURLGenerator csUrlGenerator = null;
        if (singleRepositoryName != null) {
            revUrlGenerator = this.constructCategoryURLGenerator(singleRepositoryName, fisheyeUrl, project.getKey(), false);
            csUrlGenerator = this.constructCategoryURLGenerator(singleRepositoryName, fisheyeUrl, project.getKey(), true);
        }
        String linesAddedDesc = " " + this.getText("fisheye.project.tab.tooltip.lines.added");
        String linesRemovedDesc = " " + this.getText("fisheye.project.tab.tooltip.lines.removed");
        String revisionsDesc = " " + this.getText("fisheye.project.tab.tooltip.files");
        String commitsDesc = " " + this.getText("fisheye.project.tab.tooltip.commits");
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayRevisions, "drev90", revisionsDesc, revUrlGenerator));
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayChangesets, "dcs90", commitsDesc, csUrlGenerator));
        this.tailMap((Map<String, Integer>)dayRevisions, 60);
        this.tailMap((Map<String, Integer>)dayChangesets, 60);
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayRevisions, "drev30", revisionsDesc, revUrlGenerator));
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayChangesets, "dcs30", commitsDesc, csUrlGenerator));
        this.tailMap((Map<String, Integer>)dayRevisions, 23);
        this.tailMap((Map<String, Integer>)dayChangesets, 23);
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayRevisions, "drev7", revisionsDesc, revUrlGenerator));
        params.putAll(this.chartManager.generateColumnChart((Map<String, Integer>)dayChangesets, "dcs7", commitsDesc, csUrlGenerator));
    }

    protected String getText(String key) {
        return this.getI18nBean().getText(key);
    }

    protected String getText(String key, String p0) {
        return this.getI18nBean().getText(key, p0);
    }

    private I18nHelper getI18nBean() {
        if (i18nBean == null) {
            i18nBean = this.authenticationContext.getI18nHelper();
        }
        return i18nBean;
    }

    private CategoryURLGenerator constructCategoryURLGenerator(final String repName, final String fisheyeUrl, final String projectKey, final boolean groupByChangeset) {
        return new CategoryURLGenerator(){

            public String generateURL(CategoryDataset data, int series, int category) {
                String dateString = (String)((Object)data.getColumnKey(category));
                EyeQLQuery query = new EyeQLQuery();
                if (FishEyeProjectTabPanel.this.repositoryPathStore.hasRepositoryPath(projectKey)) {
                    RepositoryPath repPath = FishEyeProjectTabPanel.this.repositoryPathStore.getRepositoryPath(projectKey);
                    query.setDir(repPath.getPath());
                    query.addWhereClause(WhereClauseFactory.betweenDates(dateString, dateString + "+P1D"));
                } else {
                    query.setDir("/");
                    query.addWhereClause(WhereClauseFactory.betweenDates(dateString, dateString + "+P1D"));
                    query.addWhereClause(WhereClauseFactory.projectKeyMatches(projectKey));
                }
                if (groupByChangeset) {
                    query.setGroupBy("changeset");
                }
                String encodedQuery = null;
                try {
                    encodedQuery = URLEncoder.encode(query.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("error", (Throwable)e);
                }
                StringBuilder url = new StringBuilder().append(fisheyeUrl).append("search/").append(repName).append("/?ql=").append(encodedQuery);
                return url.toString();
            }
        };
    }

    private void tailMap(Map<String, Integer> dayChangesets, int n) {
        Iterator<Map.Entry<String, Integer>> iterator = dayChangesets.entrySet().iterator();
        while (iterator.hasNext() && n-- > 0) {
            iterator.next();
            iterator.remove();
        }
    }

    protected List<String> getIssueKeysFromString(String s) {
        return FishEyeUtil.getIssueKeysFromString(s);
    }

    protected void createDisplayedChangesetCharts(ChangeSets changesets, Map<String, Object> params, final String singleRepositoryName, final String fisheyeUrl, String projectKey) {
        HashMap authorChangesets = Maps.newHashMap();
        HashMap authorRevisions = Maps.newHashMap();
        HashMap issueChangesets = Maps.newHashMap();
        HashMap issueRevisions = Maps.newHashMap();
        for (Changeset cs : changesets.getChangesets()) {
            this.incMapValue(authorChangesets, cs.getAuthor());
            this.incMapValue(authorRevisions, cs.getAuthor(), cs.getRevisionCount());
            String correctPrefix = projectKey.toUpperCase() + '-';
            List<String> issueKeys = this.getIssueKeysFromString(cs.getMsg());
            boolean added = false;
            for (String issueKey : issueKeys) {
                if (!(issueKey = issueKey.toUpperCase(Locale.US)).startsWith(correctPrefix)) continue;
                this.incMapValue(issueChangesets, issueKey);
                this.incMapValue(issueRevisions, issueKey, cs.getRevisionCount());
                added = true;
            }
            if (added) continue;
            if (cs.getAssociatedProjectKey() != null) {
                String otherIssueKey = this.getText("fisheye.project.tab.other.issue.key", cs.getAssociatedProjectKey());
                this.incMapValue(issueChangesets, otherIssueKey);
                this.incMapValue(issueRevisions, otherIssueKey, cs.getRevisionCount());
                continue;
            }
            String notIssueKey = this.getText("fisheye.project.tab.non.project.key", projectKey);
            this.incMapValue(issueChangesets, notIssueKey);
            this.incMapValue(issueRevisions, notIssueKey, cs.getRevisionCount());
        }
        PieURLGenerator authorUrlGenerator = null;
        if (singleRepositoryName != null) {
            authorUrlGenerator = new PieURLGenerator(){

                public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
                    if (key.equals(FishEyeProjectTabPanel.PIE_SEGMENT_OTHER)) {
                        return null;
                    }
                    return fisheyeUrl + "browse/~author=" + key + "/" + singleRepositoryName;
                }
            };
        }
        params.putAll(this.chartManager.generatePieChart(authorRevisions, "arev", authorUrlGenerator, 1));
        params.putAll(this.chartManager.generatePieChart(authorChangesets, "acs", authorUrlGenerator, 1));
        final String baseUrl = this.applicationProperties.getString("jira.baseurl");
        PieURLGenerator issueUrlGenerator = new PieURLGenerator(){

            public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
                if (key.equals(FishEyeProjectTabPanel.PIE_SEGMENT_OTHER)) {
                    return null;
                }
                return baseUrl + "/browse/" + key;
            }
        };
        params.putAll(this.chartManager.generatePieChart(issueRevisions, "irev", issueUrlGenerator, 1));
        params.putAll(this.chartManager.generatePieChart(issueChangesets, "ics", issueUrlGenerator, 1));
    }

    private Map<String, Integer> initMapHistoricalMap(Date then, Date now) {
        ListOrderedMap map = new ListOrderedMap();
        ArrayList keys = Lists.newArrayList();
        Integer defaultValue = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(now.getTime());
        while (calendar.getTime().compareTo(then) > 0) {
            String key = this.toDateKey(calendar.getTime());
            keys.add(key);
            calendar.add(6, -1);
        }
        Collections.reverse(keys);
        for (String key : keys) {
            map.put(key, defaultValue);
        }
        return map;
    }

    private String toDateKey(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd", this.authenticationContext.getLocale()).format(date);
    }

    private void incMapValue(Map<String, Integer> map, String key) {
        this.incMapValue(map, key, 1);
    }

    private void incMapValue(Map<String, Integer> map, String key, int increment) {
        Integer value = map.get(key);
        Integer newValue = value == null ? Integer.valueOf(increment) : Integer.valueOf(value + increment);
        map.put(key, newValue);
    }

    @Override
    protected boolean isShowPanel(BrowseContext context) {
        Project project = context.getProject();
        String projectKey = project.getKey();
        boolean validConfig = this.fisheyeManager.hasValidConfig();
        log.debug("FE manager has valid config = " + validConfig);
        return this.showPanelHelper.showProjectPanel(context, project, this.fisheyeManager, projectKey, validConfig, ShowPanelHelper.PageType.PROJECT_TAB_FE);
    }

    @Override
    protected String selectedTabKey() {
        return "com.atlassian.jirafisheyeplugin:fisheye-projectpanel";
    }
}

