/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.projecttabpanel.crucible;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewIdComparator;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewList;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangesetDateComparator;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.atlassian.jirafisheyeplugin.web.ShowPanelHelper;
import com.atlassian.jirafisheyeplugin.web.errorbeans.ErrorBeanUtils;
import com.atlassian.jirafisheyeplugin.web.projecttabpanel.AbstractFishEyeProjectTabPanel;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBeanFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrucibleProjectTabPanel
extends AbstractFishEyeProjectTabPanel
implements ProjectTabPanel {
    private static Logger log = LoggerFactory.getLogger(CrucibleProjectTabPanel.class);
    private static I18nHelper i18nBean = null;
    private static final String MODE_REVIEWS = "reviews";
    private static final String MODE_BY_ISSUE = "byissue";
    private static final String MODE_STATISTICS = "stats";
    private static final String CRUCIBLE_PROJECT_PANEL_MODE = "crucible.project.panel.mode";
    private FishEyeManager fisheyeManager;
    private ReviewManager reviewManager;
    private IssueManager issueManager;
    private JiraAuthenticationContext authenticationContext;
    private WikiRendererBeanFactory wikiRendererBeanFactory;
    private FishEyeConfig fisheyeConfig;
    private ShowPanelHelper showPanelHelper;
    private final ErrorBeanUtils errorBeanUtils;

    public CrucibleProjectTabPanel(FishEyeManager fisheyeManager, ReviewManager reviewManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, WikiRendererBeanFactory wikiRendererBeanFactory, FishEyeConfig fisheyeConfig, WebResourceManager webResourceManager, ShowPanelHelper showPanelHelper, VelocityRequestContextFactory velocityRequestContextFactory, ErrorBeanUtils errorBeanUtils, SoftwareLicenseVerifier softwareLicenseVerifier) {
        super(authenticationContext, velocityRequestContextFactory, softwareLicenseVerifier, webResourceManager);
        this.fisheyeManager = fisheyeManager;
        this.reviewManager = reviewManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.wikiRendererBeanFactory = wikiRendererBeanFactory;
        this.fisheyeConfig = fisheyeConfig;
        this.showPanelHelper = showPanelHelper;
        this.errorBeanUtils = errorBeanUtils;
    }

    public String getHtml(BrowseContext context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jfpTextutils", new JiraFisheyeEscapeTools());
        if (!this.fisheyeManager.hasValidConfig()) {
            log.debug("Legacy project preview tab content. Here should not be reached.");
            return "";
        }
        Project project = context.getProject();
        params.put("project", project);
        String fisheyeUrl = this.resolveCrucibleBaseUrl(project);
        params.put("fisheyeurl", fisheyeUrl);
        if (this.fisheyeConfig.isWikiRenderingEnabled()) {
            params.put("wikirenderer", this.wikiRendererBeanFactory.constructBean(project));
        }
        String mode = this.calculateMode();
        params.put("mode", mode);
        int daysPreviousToSearch = this.fisheyeConfig.getMaxCruDaysSearch();
        params.put("maxdays", String.valueOf(daysPreviousToSearch));
        try {
            if (MODE_REVIEWS.equals(mode)) {
                this.displayModeRecentReviews(project, daysPreviousToSearch, params);
            } else if (MODE_BY_ISSUE.equals(mode)) {
                this.displayModeReviewsByIssue(project, daysPreviousToSearch, params);
            } else {
                log.error("Unknown CrucibleProjectTabPanel mode: '" + mode + "'");
            }
        }
        catch (IOException e) {
            log.error("CrucibleProjectTabPanel failed to load", (Throwable)e);
            return new GenericMessageAction("Error communicating with Crucible: " + e.getClass().getName() + ": " + e.getMessage()).getHtml();
        }
        params.put("ignoredServerCount", this.errorBeanUtils.resolveIgnoredApplicationLinksForUser().size());
        return this.descriptor.getHtml("viewprojectreviews", params);
    }

    protected String resolveCrucibleBaseUrl(Project project) {
        Collection<FishEyeRepository> reps = this.fisheyeManager.getRepositoriesForProject(project.getKey());
        Iterator<FishEyeRepository> iterator = reps.iterator();
        while (iterator.hasNext()) {
            FishEyeRepository rep = iterator.next();
            if (rep.getInstance().isCru()) continue;
            iterator.remove();
        }
        return this.fisheyeManager.resolveFishEyeBaseUrl(reps);
    }

    private void displayModeRecentReviews(Project project, int daysPreviousToSearch, Map<String, Object> params) throws IOException {
        ReviewList reviewList = this.reviewManager.getReviewsForProject(project, daysPreviousToSearch);
        if (reviewList.hasErrors()) {
            params.put("string", new StringUtils());
            params.put("oAuthErrors", this.errorBeanUtils.extractOAuthErrors(reviewList.getErrors(), this.projectTabPanelURI(project.getKey())));
            params.put("reperrors", this.errorBeanUtils.extractNonOAuthErrors(reviewList.getErrors()));
            params.put("erri18n", "crucible.issue.tab.rep.error.header");
            params.put("i18nLoginKey", "fisheye.oauth.login.to.view.reviews");
        }
        List<Review> reviews = reviewList.getReviews();
        Collections.sort(reviews, ReviewIdComparator.REVERSE_COMPARATOR);
        params.put(MODE_REVIEWS, reviews);
    }

    private void displayModeReviewsByIssue(Project project, int daysPreviousToSearch, Map<String, Object> params) throws IOException {
        HashMap<String, IssueReviewList> issueReviewLists = new HashMap<String, IssueReviewList>();
        ReviewList reviewList = this.reviewManager.getReviewsForProject(project, daysPreviousToSearch);
        if (reviewList.hasErrors()) {
            params.put("oAuthErrors", this.errorBeanUtils.extractOAuthErrors(reviewList.getErrors(), this.projectTabPanelURI(project.getKey())));
            params.put("reperrors", this.errorBeanUtils.extractNonOAuthErrors(reviewList.getErrors()));
            params.put("erri18n", "crucible.issue.tab.rep.error.header");
            params.put("i18nLoginKey", "fisheye.oauth.login.to.view.reviews");
        }
        List<Review> reviews = reviewList.getReviews();
        for (Review r : reviews) {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(this.getIssueKeysFromString(r.getDescription()));
            keys.addAll(this.getIssueKeysFromString(r.getTitle()));
            if (r.getP4JobIds() != null) {
                keys.addAll(r.getP4JobIds());
            }
            for (String key : keys) {
                MutableIssue issue;
                if (!key.startsWith(project.getKey()) || (issue = this.issueManager.getIssueObject(key)) == null) continue;
                IssueReviewList listing = (IssueReviewList)issueReviewLists.get(key);
                if (listing == null) {
                    listing = new IssueReviewList((Issue)issue);
                    issueReviewLists.put(key, listing);
                }
                listing.add(r);
            }
        }
        ArrayList irs = new ArrayList(issueReviewLists.values());
        Iterator it = irs.iterator();
        while (it.hasNext()) {
            IssueReviewList issueReviewList = (IssueReviewList)it.next();
            if (issueReviewList.isUnderOpenReview()) continue;
            it.remove();
        }
        Collections.sort(irs);
        params.put("reviewlists", irs);
    }

    private String calculateMode() {
        String mode = MODE_REVIEWS;
        HttpServletRequest request = this.getRequest();
        HttpSession session = request.getSession();
        String parameter = request.getParameter("mode");
        if (parameter != null) {
            if (MODE_REVIEWS.equals(parameter)) {
                mode = MODE_REVIEWS;
                session.removeAttribute(CRUCIBLE_PROJECT_PANEL_MODE);
            } else if (MODE_BY_ISSUE.equals(parameter)) {
                mode = MODE_BY_ISSUE;
                session.setAttribute(CRUCIBLE_PROJECT_PANEL_MODE, (Object)mode);
            } else if (MODE_STATISTICS.equals(parameter)) {
                mode = MODE_STATISTICS;
                session.setAttribute(CRUCIBLE_PROJECT_PANEL_MODE, (Object)mode);
            }
        } else if (session.getAttribute(CRUCIBLE_PROJECT_PANEL_MODE) != null) {
            mode = (String)session.getAttribute(CRUCIBLE_PROJECT_PANEL_MODE);
        }
        return mode;
    }

    protected String getText(String key) {
        if (i18nBean == null) {
            i18nBean = this.authenticationContext.getI18nHelper();
        }
        return i18nBean.getText(key);
    }

    protected List<String> getIssueKeysFromString(String s) {
        return JiraKeyUtils.getIssueKeysFromString((String)s);
    }

    @Override
    protected boolean isShowPanel(BrowseContext context) {
        Project project = context.getProject();
        String projectKey = project.getKey();
        boolean crucibleEnabled = this.fisheyeManager.isCrucibleEnabled(project);
        log.debug("crucible integration is enabled = " + crucibleEnabled);
        boolean validConfig = this.fisheyeManager.hasValidConfig();
        log.debug("FE manager has valid config = " + validConfig);
        boolean showPanelDetails = this.showPanelHelper.showProjectPanel(context, project, this.fisheyeManager, projectKey, validConfig, ShowPanelHelper.PageType.PROJECT_TAB_CRU);
        boolean showPanel = validConfig ? crucibleEnabled && showPanelDetails : showPanelDetails;
        return showPanel;
    }

    @Override
    protected String selectedTabKey() {
        return "com.atlassian.jirafisheyeplugin:crucible-projectpanel";
    }

    public static class IssueChangesets
    extends AbstractIssueSkeleton {
        private List<Changeset> changesets = new ArrayList<Changeset>();

        public IssueChangesets(Issue issue) {
            super(issue);
        }

        public void add(Changeset cs) {
            this.changesets.add(cs);
        }

        public List getChangesets() {
            Collections.sort(this.changesets, ChangesetDateComparator.REVERSE_CHRONOLOGICAL);
            return this.changesets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueChangesets that = (IssueChangesets)o;
            return this.changesets == null ? that.changesets == null : this.changesets.equals(that.changesets);
        }

        public int hashCode() {
            return this.changesets != null ? this.changesets.hashCode() : 0;
        }
    }

    public static class IssueReviewList
    extends AbstractIssueSkeleton {
        private List<Review> reviews = new ArrayList<Review>();
        private boolean underOpenReview = false;

        public IssueReviewList(Issue issue) {
            super(issue);
        }

        public void add(Review r) {
            if (r.isOpen()) {
                this.underOpenReview = true;
            }
            this.reviews.add(r);
        }

        public List<Review> getReviews() {
            Collections.sort(this.reviews, ReviewIdComparator.COMPARATOR);
            return this.reviews;
        }

        public boolean isUnderOpenReview() {
            return this.underOpenReview;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueReviewList that = (IssueReviewList)o;
            return this.reviews != null ? this.reviews.equals(that.reviews) : that.reviews == null;
        }

        public int hashCode() {
            int result = this.reviews != null ? this.reviews.hashCode() : 0;
            return result;
        }
    }

    public static abstract class AbstractIssueSkeleton
    implements Comparable {
        private IssueType type;
        private String key;
        private String summary;
        private Priority priority;

        public AbstractIssueSkeleton(Issue issue) {
            this.type = issue.getIssueTypeObject();
            this.key = issue.getKey();
            this.summary = issue.getSummary();
            this.priority = issue.getPriorityObject();
        }

        public IssueType getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getSummary() {
            return this.summary;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof AbstractIssueSkeleton)) {
                return 1;
            }
            int id1 = this.parseIdNumber(this.key);
            int id2 = this.parseIdNumber(((AbstractIssueSkeleton)o).getKey());
            return id1 - id2;
        }

        private int parseIdNumber(String key) {
            return Integer.parseInt(key.substring(key.indexOf(45) + 1));
        }
    }
}

