/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.projecttabpanel;

import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public abstract class AbstractFishEyeProjectTabPanel
extends AbstractProjectTabPanel {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;
    private final WebResourceManager webResourceManager;

    protected AbstractFishEyeProjectTabPanel(JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, SoftwareLicenseVerifier softwareLicenseVerifier, WebResourceManager webResourceManager) {
        super(jiraAuthenticationContext);
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.softwareLicenseVerifier = softwareLicenseVerifier;
        this.webResourceManager = webResourceManager;
    }

    protected final URI projectTabPanelURI(String projectKey) {
        JiraFisheyeEscapeTools esc = new JiraFisheyeEscapeTools();
        return URI.create(String.format("%s/browse/%s?selectedTab=%s", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), esc.encodeUrl(projectKey), esc.encodeUrl(this.selectedTabKey())));
    }

    protected HttpServletRequest getRequest() {
        return ActionContext.getRequest();
    }

    protected abstract String selectedTabKey();

    protected abstract boolean isShowPanel(BrowseContext var1);

    public final boolean showPanel(BrowseContext ctx) {
        if (!this.isSoftwareConditionsSupported(ctx)) {
            return false;
        }
        boolean isShowPanel = this.isShowPanel(ctx);
        if (isShowPanel) {
            this.webResourceManager.requireResource("com.atlassian.jirafisheyeplugin:css");
        }
        return isShowPanel;
    }

    private boolean isSoftwareConditionsSupported(BrowseContext ctx) {
        ApplicationUser user = ctx.getUser();
        Project project = ctx.getProject();
        if (!this.softwareLicenseVerifier.isAllowedForSoftwareUsers(project, user)) {
            this.log.trace("Not showing panel because the user has no devtools permission");
            return false;
        }
        return true;
    }
}

