/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.gadgets.AbstractResource;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/more-changesets")
@Produces(value={"application/json"})
public class MoreChangesetsIssueActionResource
extends AbstractResource {
    private final IssueManager issueManager;
    private final ChangeSetManager changeSetManager;
    private final FishEyeRepositoryManager fishEyeRepositoryManager;
    private final FishEyeInstanceManager fisheyeInstanceManager;
    @Context
    private UriInfo uriInfo;

    public MoreChangesetsIssueActionResource(FishEyeRestApiManager apiManager, IssueManager issueManager, ChangeSetManager changeSetManager, FishEyeRepositoryManager fishEyeRepositoryManager, FishEyeInstanceManager fisheyeInstanceManager) {
        super(apiManager);
        this.issueManager = issueManager;
        this.changeSetManager = changeSetManager;
        this.fishEyeRepositoryManager = fishEyeRepositoryManager;
        this.fisheyeInstanceManager = fisheyeInstanceManager;
    }

    @GET
    @Path(value="{issueKey}/{applicationId:.*}")
    public Response changesets(@PathParam(value="issueKey") String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        Map<FishEyeRepository, Integer> searchIndex = this.computeSearchIndexFrom(this.uriInfo, issueKey);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new ResultBuilder().setChangesets(this.computeMoreChangesets((Issue)issue, searchIndex)).build()).build();
    }

    private Map<FishEyeRepository, Integer> computeSearchIndexFrom(UriInfo uriInfo, final String issueKey) {
        HashMap repositoryToSearchIndex = Maps.newHashMap();
        ArrayList pathSegments = Lists.newArrayList((Iterable)Iterables.filter((Iterable)uriInfo.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

            public boolean apply(PathSegment input) {
                String path = input.getPath();
                return !issueKey.equals(path) && !"more-changesets".equals(path);
            }
        }));
        for (PathSegment pathSegment : pathSegments) {
            String path = pathSegment.getPath();
            ApplicationId id = new ApplicationId(path);
            MultivaluedMap matrixParameters = pathSegment.getMatrixParameters();
            Set repositoryNames = matrixParameters.entrySet();
            for (Map.Entry repositoryParam : repositoryNames) {
                String repositoryName = (String)repositoryParam.getKey();
                Integer idx = Integer.parseInt((String)((List)repositoryParam.getValue()).get(0), 10);
                FishEyeRepository repository = this.fishEyeRepositoryManager.load(this.fisheyeInstanceManager.load(id), repositoryName);
                repositoryToSearchIndex.put(repository, idx);
            }
        }
        return repositoryToSearchIndex;
    }

    private List<MoreChangeset> computeMoreChangesets(Issue issue, Map<FishEyeRepository, Integer> searchIndex) {
        return Lists.transform(this.changeSetManager.getMoreChangesets(issue, searchIndex), (Function)new Function<Changeset, MoreChangeset>(){

            public MoreChangeset apply(Changeset cs) {
                return new MoreChangesetBuilder().setCsid(cs.getCsid()).setRepositoryName(cs.getRep()).setUri(UriBuilder.fromUri((String)cs.getBaseUrl()).path("changelog").path(cs.getRep()).queryParam("cs", new Object[]{cs.getCsid()}).build(new Object[0])).build();
            }
        });
    }

    @XmlRootElement(name="changeset")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class MoreChangeset {
        @XmlElement(name="repository")
        private String repositoryName;
        @XmlElement(name="csid")
        private String csid;
        @XmlElement(name="uri")
        private URI uri;

        public MoreChangeset() {
        }

        public MoreChangeset(String repositoryName, String csid, URI uri) {
            this.repositoryName = repositoryName;
            this.csid = csid;
            this.uri = uri;
        }

        public String getCsid() {
            return this.csid;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public URI getUri() {
            return this.uri;
        }
    }

    @XmlRootElement(name="more-changesets")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class MoreChangesetsResult {
        @XmlElement(name="changesets")
        private List<MoreChangeset> changesets;

        public MoreChangesetsResult() {
        }

        public MoreChangesetsResult(List<MoreChangeset> changesets) {
            this.changesets = changesets;
        }

        public List<MoreChangeset> getChangesets() {
            return this.changesets;
        }

        public void setChangesets(List<MoreChangeset> changesets) {
            this.changesets = changesets;
        }
    }

    private static class ResultBuilder {
        private List<MoreChangeset> changesets;

        private ResultBuilder() {
        }

        public MoreChangesetsResult build() {
            return new MoreChangesetsResult(this.changesets);
        }

        public ResultBuilder setChangesets(List<MoreChangeset> changesets) {
            this.changesets = changesets;
            return this;
        }
    }

    private static class MoreChangesetBuilder {
        private String repositoryName;
        private String csid;
        private URI uri;

        private MoreChangesetBuilder() {
        }

        public MoreChangeset build() {
            return new MoreChangeset(this.repositoryName, this.csid, this.uri);
        }

        public MoreChangesetBuilder setCsid(String csid) {
            this.csid = csid;
            return this;
        }

        public MoreChangesetBuilder setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public MoreChangesetBuilder setUri(URI uri) {
            this.uri = uri;
            return this;
        }
    }
}

