/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.gadgets.AbstractResource;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.AbstractFishEyeCrucibleIssueTabPanel;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.rest.AjaxResult;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Produces(value={"application/json"})
public class AjaxTabPanelResource
extends AbstractResource {
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;

    public AjaxTabPanelResource(FishEyeRestApiManager apiManager, IssueManager issueManager, PluginAccessor pluginAccessor, JiraAuthenticationContext jiraAuthenticationContext) {
        super(apiManager);
        this.issueManager = issueManager;
        this.pluginAccessor = pluginAccessor;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @POST
    @Path(value="/{pluginKey}/{issueKey}")
    public Response generate(@PathParam(value="pluginKey") String pluginKey, @PathParam(value="issueKey") String issueKey) {
        ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(pluginKey);
        if (descriptor == null) {
            throw new RuntimeException("Could not find an enabled module with key '" + pluginKey + "'");
        }
        AbstractFishEyeCrucibleIssueTabPanel panel = (AbstractFishEyeCrucibleIssueTabPanel)((Object)descriptor.getModule());
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            throw new RuntimeException("Could not find issue with key '" + issueKey + "'");
        }
        List<IssueAction> actions = panel.createActions((Issue)issue, this.jiraAuthenticationContext.getLoggedInUser(), true);
        return this.createOkResponse(this.renderActionList(actions));
    }

    private AjaxResult renderActionList(List<IssueAction> actions) {
        StringBuilder sb = new StringBuilder();
        for (IssueAction action : actions) {
            sb.append(action.getHtml());
        }
        return new AjaxResult(sb.toString());
    }
}

