/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.stash.CredentialsRequest;
import com.atlassian.jirafisheyeplugin.stash.IntegrationProblem;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.atlassian.jirafisheyeplugin.web.errorbeans.ErrorBeanUtils;
import com.atlassian.jirafisheyeplugin.web.errorbeans.OAuthErrorBean;
import com.atlassian.jirafisheyeplugin.web.errorbeans.RepositoryErrorBean;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ViewRepositoryErrorsAction
extends AbstractIssueAction {
    private final List<RepositoryErrorBean> errors;
    private final List<OAuthErrorBean> oAuthErrors;
    private String i18nErrorMessageKey = "fisheye.issue.tab.rep.error.header";
    private String i18nLoginKey = "fisheye.oauth.login.to.view.changesets";

    public ViewRepositoryErrorsAction(Collection<SourceErrorReport> errors, IssueTabPanelModuleDescriptor issueTabPanelModuleDescriptor, URI callbackURI, ErrorBeanUtils errorBeanUtils) {
        this(errors, Collections.emptyList(), Collections.emptyList(), issueTabPanelModuleDescriptor, callbackURI, errorBeanUtils);
    }

    public ViewRepositoryErrorsAction(Collection<SourceErrorReport> feRepositoryErrors, Collection<CredentialsRequest> credentialsRequests, Collection<IntegrationProblem> stashErrors, IssueTabPanelModuleDescriptor issueTabPanelModuleDescriptor, URI callbackURI, ErrorBeanUtils errorBeanUtils) {
        super(issueTabPanelModuleDescriptor);
        this.errors = errorBeanUtils.extractNonOAuthErrors(feRepositoryErrors, stashErrors);
        this.oAuthErrors = errorBeanUtils.extractOAuthErrors(feRepositoryErrors, credentialsRequests, callbackURI);
    }

    public void setI18nErrorMessageKey(String i18nErrorMessageKey) {
        this.i18nErrorMessageKey = i18nErrorMessageKey;
    }

    public ViewRepositoryErrorsAction i18nLoginKey(String i18nLoginKey) {
        this.i18nLoginKey = i18nLoginKey;
        return this;
    }

    public String getHtml() {
        Map params = EasyMap.build((Object)"string", (Object)new StringUtils(), (Object)"oAuthErrors", this.oAuthErrors, (Object)"reperrors", this.errors, (Object)"erri18n", (Object)this.i18nErrorMessageKey, (Object)"i18nLoginKey", (Object)this.i18nLoginKey, (Object)"jfpTextutils", (Object)new JiraFisheyeEscapeTools());
        return this.descriptor.getHtml("viewreperrors", params);
    }

    public Date getTimePerformed() {
        return new Date(System.currentTimeMillis());
    }

    protected void populateVelocityParams(Map map) {
    }
}

