/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewChangeSetsSummaryAction
extends AbstractIssueAction {
    private static final Logger log = LoggerFactory.getLogger(ViewChangeSetsSummaryAction.class);
    private final List<Changeset> changesets;
    private final String issueKey;
    private final String wordingi18nKey;
    private final Map<FishEyeRepository, Integer> searchIndex;
    private final boolean noAjax;

    public ViewChangeSetsSummaryAction(Map<FishEyeRepository, Integer> searchIndex, boolean noAjax, Issue issue, String wordingI18nKey, List<Changeset> changesets, IssueTabPanelModuleDescriptor descriptor) {
        super(descriptor);
        this.searchIndex = searchIndex;
        this.noAjax = noAjax;
        this.issueKey = issue.getKey();
        this.wordingi18nKey = wordingI18nKey;
        this.changesets = changesets;
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public String getWordingI18nKey() {
        return this.wordingi18nKey;
    }

    public String getHtml() {
        ImmutableMap params = ImmutableMap.builder().put((Object)"noAjax", (Object)this.noAjax).put((Object)"searchIndexParam", (Object)this.computeMatrixPath(this.searchIndex)).put((Object)"wordingI18nKey", (Object)this.wordingi18nKey).put((Object)"summarisedchangesets", this.changesets).put((Object)"jfpTextutils", (Object)new JiraFisheyeEscapeTools()).put((Object)"issueKey", (Object)this.issueKey).build();
        return this.descriptor.getHtml("viewcslist", (Map)params);
    }

    private String computeMatrixPath(Map<FishEyeRepository, Integer> searchIndex) {
        HashMap instancesToRepMap = Maps.newHashMap();
        UriBuilder builder = UriBuilder.fromPath((String)"/");
        for (Map.Entry<FishEyeRepository, Integer> entry : searchIndex.entrySet()) {
            if (entry.getKey() == null) continue;
            if (!instancesToRepMap.containsKey(entry.getKey())) {
                instancesToRepMap.put(entry.getKey().getInstance().getApplicationId(), Lists.newArrayList());
            }
            ((List)instancesToRepMap.get(entry.getKey().getInstance().getApplicationId())).add(entry.getKey());
        }
        for (Map.Entry<FishEyeRepository, Integer> entry : instancesToRepMap.entrySet()) {
            builder.path(((ApplicationId)entry.getKey()).get());
            for (FishEyeRepository fishEyeRepository : (List)((Object)entry.getValue())) {
                builder.matrixParam(fishEyeRepository.getName(), new Object[]{searchIndex.get(fishEyeRepository)});
            }
        }
        String path = builder.build(new Object[0]).toASCIIString();
        if (log.isDebugEnabled()) {
            log.debug("matrix param path:" + path);
        }
        return path;
    }

    public Date getTimePerformed() {
        return new Timestamp(System.currentTimeMillis());
    }

    protected void populateVelocityParams(Map map) {
    }
}

