/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBean;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ViewChangeSetAction
extends AbstractIssueAction {
    private Changeset cs;
    private Date timestamp;
    private List<Review> reviews = null;
    private WikiRendererBean wikiRendererBean;
    @Nullable
    private final String linkedCrucibleProject;
    private final JiraAuthenticationContext authContext;

    public ViewChangeSetAction(Changeset cs, IssueTabPanelModuleDescriptor descriptor, List<Review> reviews, @Nullable String linkedCrucibleProject, WikiRendererBean wikiRendererBean, JiraAuthenticationContext authContext) {
        super(descriptor);
        this.cs = cs;
        this.linkedCrucibleProject = linkedCrucibleProject;
        this.timestamp = cs.getDate();
        this.reviews = reviews;
        this.wikiRendererBean = wikiRendererBean;
        this.authContext = authContext;
    }

    public ViewChangeSetAction(Changeset cs, IssueTabPanelModuleDescriptor descriptor, WikiRendererBean wikiRendererBean, JiraAuthenticationContext authContext) {
        super(descriptor);
        this.cs = cs;
        this.timestamp = cs.getDate();
        this.wikiRendererBean = wikiRendererBean;
        this.linkedCrucibleProject = null;
        this.authContext = authContext;
    }

    public List<Review> getReviews() {
        return this.reviews;
    }

    public Changeset getChangeset() {
        return this.cs;
    }

    public String getHtml() {
        Map<String, Object> params = this.constructFishEyeVelocityContentMap();
        return this.descriptor.getHtml("viewcs", params);
    }

    protected Map<String, Object> constructFishEyeVelocityContentMap() {
        Map params = EasyMap.build((Object)"changeset", (Object)this.cs);
        if (this.cs.isCru()) {
            params.put("isCru", "true");
            if (this.reviews != null && !this.reviews.isEmpty()) {
                params.put("reviews", this.reviews);
                params.put("hasReviewsLinks", true);
            }
            if (this.linkedCrucibleProject != null) {
                params.put("crucibleProject", this.linkedCrucibleProject);
            }
        }
        if (this.wikiRendererBean != null) {
            params.put("wikirenderer", this.wikiRendererBean);
        }
        params.put("jfpTextutils", new JiraFisheyeEscapeTools());
        params.put("locale", this.authContext.getLocale());
        return params;
    }

    public Date getTimePerformed() {
        return this.timestamp;
    }

    protected void populateVelocityParams(Map map) {
    }
}

