/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSets;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.jira.IssueHelper;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.stash.Commit;
import com.atlassian.jirafisheyeplugin.stash.CommitSearchResults;
import com.atlassian.jirafisheyeplugin.stash.StashCommitAction;
import com.atlassian.jirafisheyeplugin.stash.StashCommitService;
import com.atlassian.jirafisheyeplugin.stash.StashTruncatedResultsAction;
import com.atlassian.jirafisheyeplugin.web.ShowPanelHelper;
import com.atlassian.jirafisheyeplugin.web.errorbeans.ErrorBeanUtils;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.AbstractFishEyeCrucibleIssueTabPanel;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye.CreateReviewForIssueChangesetsAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye.ViewChangeSetAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye.ViewChangeSetsSummaryAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye.ViewRepositoryErrorsAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.generic.IgnoredApplicationLinksAction;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBean;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBeanFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeIssueTabPanel
extends AbstractFishEyeCrucibleIssueTabPanel {
    private static final Logger log = LoggerFactory.getLogger(FishEyeIssueTabPanel.class);
    private final FishEyeManager fisheyeManager;
    private final ChangeSetManager changeSetManager;
    private final ReviewManager reviewManager;
    private final IssueHelper issueHelper;
    private final FishEyeInstanceStore instanceStore;
    private final FishEyeConfig fisheyeConfig;
    private final WikiRendererBeanFactory wikiRendererBeanFactory;
    private final CrucibleProjectStore crucibleProjectStore;
    private final ShowPanelHelper showPanelHelper;
    private final ErrorBeanUtils errorBeanUtils;
    private final StashCommitService stashCommitService;

    public FishEyeIssueTabPanel(FishEyeManager fisheyeManager, ChangeSetManager changeSetManager, ReviewManager reviewManager, JiraAuthenticationContext authenticationContext, IssueHelper issueHelper, WikiRendererBeanFactory wikiRendererBeanFactory, FishEyeInstanceStore instanceStore, FishEyeConfig fisheyeConfig, CrucibleProjectStore crucibleProjectStore, WebResourceManager webResourceManager, ShowPanelHelper showPanelHelper, VelocityRequestContextFactory velocityRequestContextFactory, ErrorBeanUtils errorBeanUtils, StashCommitService stashCommitService, SoftwareLicenseVerifier softwareLicenseVerifier) {
        super(webResourceManager, authenticationContext, velocityRequestContextFactory, softwareLicenseVerifier);
        this.fisheyeManager = fisheyeManager;
        this.changeSetManager = changeSetManager;
        this.reviewManager = reviewManager;
        this.issueHelper = issueHelper;
        this.instanceStore = instanceStore;
        this.fisheyeConfig = fisheyeConfig;
        this.wikiRendererBeanFactory = wikiRendererBeanFactory;
        this.crucibleProjectStore = crucibleProjectStore;
        this.showPanelHelper = showPanelHelper;
        this.errorBeanUtils = errorBeanUtils;
        this.stashCommitService = stashCommitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IssueAction> createActions(Issue issue, ApplicationUser remoteUser, boolean useAjax) {
        ArrayList results = Lists.newArrayList();
        String createActionTimer = "FishEyeIssueTabPanel.createActions()";
        try {
            CommitSearchResults stashResults = this.stashCommitService.findCommits(issue);
            UtilTimerStack.push((String)"FishEyeIssueTabPanel.createActions()");
            ChangeSets changesets = this.changeSetManager.getChangesetsForIssue(issue);
            this.addErrorsAndOAuthRequests(issue, results, changesets, stashResults);
            results.addAll(Lists.transform(stashResults.getCommits(), (Function)new Function<Commit, IssueAction>(){

                public IssueAction apply(@Nullable Commit commit) {
                    return new StashCommitAction(FishEyeIssueTabPanel.this.descriptor, commit);
                }
            }));
            if (!stashResults.getServersWithTruncatedResults().isEmpty()) {
                results.add(new StashTruncatedResultsAction(this.descriptor, stashResults));
            }
            if (this.fisheyeConfig.isSearchForMovedIssues()) {
                this.addOldChangesets(issue, changesets);
            }
            this.securityFilterChangesets(remoteUser, changesets);
            if (changesets.getChangesets().size() > 0 || changesets.isIncomplete()) {
                this.addCreateCrucibleReviewHeader(issue, results, changesets);
                this.addChangeSetActions(issue, results, changesets);
                this.addSummarisedChangeSetActions(issue, results, changesets, !useAjax);
            }
            if (results.isEmpty()) {
                results.add(this.getGenericMessageAction(this.getText("fisheye.issue.tab.no.commits")));
            }
            this.addIgnoredApplicationLinksAction(results);
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (IllegalStateException e) {
            log.error("FishEyeIssueTabPanel failed to load: ", (Throwable)e);
            results.add(this.getGenericMessageAction("FishEyeIssueTabPanel failed to load: " + e));
        }
        catch (IOException e) {
            log.error("FishEyeIssueTabPanel failed to load: ", (Throwable)e);
            results.add(this.getGenericMessageAction(this.getText("fisheye.issue.tab.error.io") + ": " + e));
        }
        finally {
            UtilTimerStack.pop((String)"FishEyeIssueTabPanel.createActions()");
        }
        return results;
    }

    private void addIgnoredApplicationLinksAction(List<IssueAction> results) {
        IgnoredApplicationLinksAction ignoredApplicationLinksAction = new IgnoredApplicationLinksAction(this.descriptor, this.errorBeanUtils);
        if (ignoredApplicationLinksAction.isApplicable()) {
            results.add(ignoredApplicationLinksAction);
        }
    }

    protected void addSummarisedChangeSetActions(Issue issue, List<IssueAction> results, ChangeSets changesets, boolean isNoAjax) {
        if (changesets.isIncomplete()) {
            int maxIssueChangeSets = this.fisheyeConfig.getMaxIssueChangeSets();
            String blurbI18nKey = maxIssueChangeSets == 0 ? "fisheye.issue.tab.related.changesets" : "fisheye.issue.tab.more.related.changesets";
            Map<FishEyeRepository, Integer> searchIndex = changesets.getSummaryIndex();
            List<Changeset> summarisedChangesets = changesets.getSummarisedChangesets();
            results.add((IssueAction)new ViewChangeSetsSummaryAction(searchIndex, isNoAjax, issue, blurbI18nKey, summarisedChangesets, this.descriptor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeSetActions(Issue issue, List<IssueAction> results, ChangeSets changesets) throws IOException {
        WikiRendererBean wikiRendererBean = null;
        if (this.fisheyeConfig.isWikiRenderingEnabled()) {
            wikiRendererBean = this.wikiRendererBeanFactory.constructBean(issue);
        }
        String changesetReviewSearchTimerkey = "FishEyeIssueTabPanel.addChangeSetActions() issue=" + issue.getKey();
        try {
            UtilTimerStack.push((String)changesetReviewSearchTimerkey);
            for (Changeset changeset : changesets.getChangesets()) {
                FishEyeInstance instance = this.inferFishEyeInstance(changeset);
                String linkedCrucibleProject = this.getLinkedCrucibleProject(issue, instance);
                if (changeset.isCru()) {
                    List<Review> reviews;
                    if (!changeset.isReviewsInitialised()) {
                        try {
                            reviews = this.reviewManager.getReviewsForChangeset(issue.getProjectObject().getKey(), changeset.getCsid(), changeset.getRep());
                        }
                        catch (IOException e) {
                            reviews = Collections.emptyList();
                            log.warn("Error getting reviews for changeset " + changeset.toString(), (Throwable)e);
                        }
                    } else {
                        reviews = changeset.getReviews();
                    }
                    results.add((IssueAction)new ViewChangeSetAction(changeset, this.descriptor, reviews, linkedCrucibleProject, wikiRendererBean, this.authenticationContext));
                    continue;
                }
                results.add((IssueAction)new ViewChangeSetAction(changeset, this.descriptor, wikiRendererBean, this.authenticationContext));
            }
        }
        finally {
            UtilTimerStack.pop((String)changesetReviewSearchTimerkey);
        }
    }

    protected void addCreateCrucibleReviewHeader(Issue issue, List<IssueAction> results, ChangeSets changesets) {
        List<Changeset> cs = changesets.getChangesets();
        if (!cs.isEmpty() && this.isAllChangesetsFromSameCrucibleInstance(cs)) {
            FishEyeInstance instance = this.inferFishEyeInstance((Changeset)cs.iterator().next());
            String linkedCrucibleProject = this.getLinkedCrucibleProject(issue, instance);
            results.add((IssueAction)new CreateReviewForIssueChangesetsAction(this.descriptor, cs, issue, instance, linkedCrucibleProject));
        }
    }

    private String getLinkedCrucibleProject(Issue issue, FishEyeInstance instance) {
        if (instance != null && this.crucibleProjectStore != null) {
            return this.crucibleProjectStore.getDefaultCrucibleProjectKey(issue.getProjectObject().getKey(), instance.getApplicationId());
        }
        return null;
    }

    protected FishEyeInstance inferFishEyeInstance(Changeset changeset) {
        FishEyeInstance instance = this.instanceStore.getFishEyeInstanceByUrl(changeset.getBaseUrl());
        if (instance != null) {
            return instance;
        }
        return this.instanceStore.getDefaultFishEyeInstance();
    }

    protected void addErrorsAndOAuthRequests(Issue issue, List<IssueAction> results, ChangeSets changesets, CommitSearchResults stashResults) {
        if (changesets.hasErrors() || !stashResults.getCredentialsRequests().isEmpty() || !stashResults.getIntegrationProblems().isEmpty()) {
            results.add((IssueAction)new ViewRepositoryErrorsAction(changesets.getErrors(), stashResults.getCredentialsRequests(), stashResults.getIntegrationProblems(), this.descriptor, this.issueTabPanelURI(issue.getKey()), this.errorBeanUtils));
        }
    }

    protected void securityFilterChangesets(ApplicationUser remoteUser, ChangeSets changesets) {
        this.fisheyeManager.filterByBrowseIssuePermission(changesets.getChangesets(), remoteUser);
    }

    protected void addOldChangesets(Issue issue, ChangeSets changesets) {
        HashSet<Changeset> oldChangesets = new HashSet<Changeset>();
        Collection<String> oldIssueKeys = this.issueHelper.getOldIssueKeys(issue.getKey());
        for (String key : oldIssueKeys) {
            String projectKey = key.substring(0, key.lastIndexOf("-"));
            List<Changeset> foundChangesets = this.changeSetManager.getChangesetsForIssue(key, projectKey).getChangesets();
            for (Changeset changeset : foundChangesets) {
                changeset.setOldKey(key);
                oldChangesets.add(changeset);
            }
        }
        oldChangesets.removeAll(changesets.getChangesets());
        changesets.getChangesets().addAll(oldChangesets);
    }

    protected boolean isAllChangesetsFromSameCrucibleInstance(Collection<Changeset> changesets) {
        String baseUrl = null;
        for (Changeset cs : changesets) {
            if (!cs.isCru()) {
                return false;
            }
            if (baseUrl != null && !baseUrl.equals(cs.getBaseUrl())) {
                return false;
            }
            baseUrl = cs.getBaseUrl();
        }
        return true;
    }

    @Override
    public final boolean isShowPanel(Issue issue, ApplicationUser remoteUser) {
        String projectKey = issue.getProjectObject().getKey();
        boolean validConfig = this.fisheyeManager.hasValidConfig() || this.stashCommitService.isConfigured();
        boolean validAndNoSummary = validConfig && (this.fisheyeManager.hasNoSummary() || this.stashCommitService.hasNoSummary());
        log.debug("FE manager has valid config = {} and no summary = {}", (Object)validConfig, (Object)validAndNoSummary);
        return this.showPanelHelper.showIssuePanel(issue, remoteUser, this.fisheyeManager, this.fisheyeConfig, projectKey, validAndNoSummary, ShowPanelHelper.PageType.ISSUE_TAB_FE);
    }

    protected GenericMessageAction getGenericMessageAction(String text) {
        return new GenericMessageAction(text);
    }

    @Override
    protected String selectedTabKey() {
        return "com.atlassian.jirafisheyeplugin:fisheye-issuepanel";
    }
}

