/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReviewForIssueChangesetsAction
extends AbstractIssueAction {
    private static Logger log = LoggerFactory.getLogger(CreateReviewForIssueChangesetsAction.class);
    private Collection<Changeset> changesets;
    private Issue issue;
    private FishEyeInstance instance;
    private String crucibleProject;

    public CreateReviewForIssueChangesetsAction(IssueTabPanelModuleDescriptor descriptor, Collection<Changeset> changesets, Issue issue, FishEyeInstance instance, String crucibleProject) {
        super(descriptor);
        this.changesets = changesets;
        this.issue = issue;
        this.instance = instance;
        this.crucibleProject = crucibleProject;
    }

    public Collection getChangesets() {
        return this.changesets;
    }

    public String getHtml() {
        String title = this.issue.getKey() + ": " + this.issue.getSummary();
        String description = this.issue.getDescription() != null ? this.issue.getDescription() : this.issue.getSummary();
        String fisheyeUrl = this.instance.getUrl();
        Map params = EasyMap.build((Object)"changesets", this.changesets, (Object)"fisheyeurl", (Object)fisheyeUrl, (Object)"title", (Object)title, (Object)"description", (Object)description, (Object)"crucibleProject", (Object)this.crucibleProject);
        params.put("jfpTextutils", new JiraFisheyeEscapeTools());
        return this.getDescriptorHtml("createissuereview", params);
    }

    protected String getDescriptorHtml(String template, Map<String, Object> params) {
        return this.descriptor.getHtml(template, params);
    }

    public Date getTimePerformed() {
        return new Date(System.currentTimeMillis());
    }

    public boolean isDisplayActionAllTab() {
        return false;
    }

    protected void populateVelocityParams(Map map) {
    }
}

