/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel.crucible;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewList;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.jira.IssueHelper;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.web.ShowPanelHelper;
import com.atlassian.jirafisheyeplugin.web.errorbeans.ErrorBeanUtils;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.AbstractFishEyeCrucibleIssueTabPanel;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.crucible.CrucibleReviewAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.fisheye.ViewRepositoryErrorsAction;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.generic.IgnoredApplicationLinksAction;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBean;
import com.atlassian.jirafisheyeplugin.web.renderer.WikiRendererBeanFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrucibleIssueTabPanel
extends AbstractFishEyeCrucibleIssueTabPanel {
    private static final Logger log = LoggerFactory.getLogger(CrucibleIssueTabPanel.class);
    private static final ReviewActionComparator REVIEW_ACTION_COMPARATOR = new ReviewActionComparator();
    private final FishEyeManager fisheyeManager;
    private final ReviewManager reviewManager;
    private final IssueHelper issueHelper;
    private final WikiRendererBeanFactory wikiRendererBeanFactory;
    private final FishEyeConfig fisheyeConfig;
    private final ShowPanelHelper showPanelHelper;
    private final ErrorBeanUtils errorBeanUtils;

    public CrucibleIssueTabPanel(FishEyeManager fisheyeManager, ReviewManager reviewManager, JiraAuthenticationContext authenticationContext, IssueHelper issueHelper, WikiRendererBeanFactory wikiRendererBeanFactory, FishEyeConfig fisheyeConfig, WebResourceManager webResourceManager, ShowPanelHelper showPanelHelper, VelocityRequestContextFactory velocityRequestContextFactory, ErrorBeanUtils errorBeanUtils, SoftwareLicenseVerifier softwareLicenseVerifier) {
        super(webResourceManager, authenticationContext, velocityRequestContextFactory, softwareLicenseVerifier);
        this.fisheyeManager = fisheyeManager;
        this.reviewManager = reviewManager;
        this.issueHelper = issueHelper;
        this.wikiRendererBeanFactory = wikiRendererBeanFactory;
        this.fisheyeConfig = fisheyeConfig;
        this.showPanelHelper = showPanelHelper;
        this.errorBeanUtils = errorBeanUtils;
    }

    @Override
    public List<IssueAction> createActions(Issue issue, ApplicationUser remoteUser, boolean useAjax) {
        ArrayList<IssueAction> results = new ArrayList<IssueAction>();
        try {
            ReviewList reviewList = this.reviewManager.getReviewsForIssue(issue);
            this.addOldReviews(issue, reviewList);
            this.addCrucibleErrors(results, reviewList, issue);
            List<Review> reviews = reviewList.getReviews();
            if (reviews.isEmpty()) {
                results.add((IssueAction)this.getGenericMessageAction(this.getText("crucible.issue.tab.no.reviews")));
            } else {
                this.addReviewActions(results, reviews, issue);
                Collections.sort(results, REVIEW_ACTION_COMPARATOR);
            }
            IgnoredApplicationLinksAction ignoredApplicationLinksAction = new IgnoredApplicationLinksAction(this.descriptor, this.errorBeanUtils);
            if (ignoredApplicationLinksAction.isApplicable()) {
                results.add(ignoredApplicationLinksAction);
            }
        }
        catch (IllegalStateException e) {
            log.error("CrucibleIssueTabPanel failed to load", (Throwable)e);
            results.add((IssueAction)this.getGenericMessageAction(e.getMessage()));
        }
        return results;
    }

    private void addReviewActions(List<IssueAction> results, List<Review> reviews, Issue issue) {
        WikiRendererBean wikiRendererBean = null;
        if (this.fisheyeConfig.isWikiRenderingEnabled()) {
            wikiRendererBean = this.wikiRendererBeanFactory.constructBean(issue);
        }
        for (Review r : reviews) {
            results.add((IssueAction)new CrucibleReviewAction(r, this.descriptor, this.fisheyeConfig, wikiRendererBean));
        }
    }

    private void addCrucibleErrors(List<IssueAction> results, ReviewList reviewList, Issue issue) {
        if (reviewList.hasErrors()) {
            ViewRepositoryErrorsAction errorAction = new ViewRepositoryErrorsAction(reviewList.getErrors(), this.descriptor, this.issueTabPanelURI(issue.getKey()), this.errorBeanUtils);
            errorAction.setI18nErrorMessageKey("crucible.issue.tab.rep.error.header");
            results.add((IssueAction)errorAction.i18nLoginKey("fisheye.oauth.login.to.view.reviews"));
        }
    }

    protected void addOldReviews(Issue issue, ReviewList reviewList) {
        HashSet<Review> oldReviews = new HashSet<Review>();
        Collection<String> oldIssueKeys = this.issueHelper.getOldIssueKeys(issue.getKey());
        for (String key : oldIssueKeys) {
            String projectKey = key.substring(0, key.lastIndexOf("-"));
            oldReviews.addAll(this.reviewManager.getReviewsForIssue(key, projectKey).getReviews());
        }
        oldReviews.removeAll(reviewList.getReviews());
        reviewList.getReviews().addAll(oldReviews);
    }

    @Override
    public final boolean isShowPanel(Issue issue, ApplicationUser remoteUser) {
        Project project = issue.getProjectObject();
        String projectKey = project.getKey();
        boolean crucibleEnabled = this.fisheyeManager.isCrucibleEnabled(project);
        log.debug("crucible integration is enabled = " + crucibleEnabled);
        boolean validConfig = this.fisheyeManager.hasValidConfig();
        boolean validAndNoSummary = validConfig && this.fisheyeManager.hasNoSummary();
        log.debug("FE manager has valid config = {} and no summary = {}", (Object)validConfig, (Object)validAndNoSummary);
        boolean showPanelDetails = this.showPanelHelper.showIssuePanel(issue, remoteUser, this.fisheyeManager, this.fisheyeConfig, projectKey, validAndNoSummary, ShowPanelHelper.PageType.ISSUE_TAB_CRU);
        if (validAndNoSummary) {
            return crucibleEnabled && showPanelDetails;
        }
        return showPanelDetails;
    }

    protected GenericMessageAction getGenericMessageAction(String text) {
        return new GenericMessageAction(text);
    }

    @Override
    protected String selectedTabKey() {
        return "com.atlassian.jirafisheyeplugin:crucible-issuepanel";
    }

    protected static class ReviewActionComparator
    implements Comparator<IssueAction> {
        protected ReviewActionComparator() {
        }

        @Override
        public int compare(IssueAction o1, IssueAction o2) {
            if (o1 == null || !(o1 instanceof CrucibleReviewAction)) {
                return -1;
            }
            if (o2 == null || !(o2 instanceof CrucibleReviewAction)) {
                return 1;
            }
            int id1 = this.parseIdNumber((CrucibleReviewAction)o1);
            int id2 = this.parseIdNumber((CrucibleReviewAction)o2);
            return id1 - id2;
        }

        private int parseIdNumber(CrucibleReviewAction cra) {
            String id = cra.getReview().getId();
            return Integer.parseInt(id.substring(id.lastIndexOf(45) + 1));
        }
    }
}

