/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.issuetabpanel;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.atlassian.jirafisheyeplugin.web.issuetabpanel.AjaxTabPanelAction;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFishEyeCrucibleIssueTabPanel
extends AbstractIssueTabPanel3 {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private I18nHelper i18nHelper;
    private final WebResourceManager webResourceManager;
    protected final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;

    public AbstractFishEyeCrucibleIssueTabPanel(WebResourceManager webResourceManager, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, SoftwareLicenseVerifier softwareLicenseVerifier) {
        this.webResourceManager = webResourceManager;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.softwareLicenseVerifier = (SoftwareLicenseVerifier)Preconditions.checkNotNull((Object)softwareLicenseVerifier, (Object)"softwareLicenseVerifier");
    }

    protected String getText(String key) {
        if (this.i18nHelper == null) {
            this.i18nHelper = this.authenticationContext.getI18nHelper();
        }
        return this.i18nHelper.getText(key);
    }

    protected final URI issueTabPanelURI(String issueKey) {
        JiraFisheyeEscapeTools esc = new JiraFisheyeEscapeTools();
        return URI.create(String.format("%s/browse/%s?page=%s#issue-tabs", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), esc.encodeUrl(issueKey), esc.encodeUrl(this.selectedTabKey())));
    }

    protected abstract String selectedTabKey();

    public final boolean showPanel(ShowPanelRequest request) {
        ApplicationUser user = request.remoteUser();
        if (!this.softwareLicenseVerifier.isAllowedForSoftwareUsers(request.issue().getProjectObject(), user)) {
            this.log.trace("Not showing panel because the user has no devtools permission");
            return false;
        }
        return this.isShowPanel(request.issue(), user);
    }

    public List<IssueAction> getActions(GetActionsRequest request) {
        boolean useAjaxLoad;
        boolean bl = useAjaxLoad = !request.isAsynchronous() && !this.isAllTab() && !this.isNoAjax();
        if (useAjaxLoad) {
            this.webResourceManager.requireResource("com.atlassian.jirafisheyeplugin:css");
            return Collections.singletonList(new AjaxTabPanelAction(this.descriptor, request.issue()));
        }
        return this.createActions(request.issue(), request.remoteUser(), useAjaxLoad);
    }

    private boolean isAllTab() {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String page = requestContext.getRequestParameter("page");
        return page != null && page.equals("com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel");
    }

    private boolean isNoAjax() {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String noAjax = requestContext.getRequestParameter("noAjax");
        return Boolean.parseBoolean(noAjax);
    }

    public final List<IssueAction> createActions(Issue issue, ApplicationUser remoteUser) {
        return this.createActions(issue, remoteUser, false);
    }

    public abstract List<IssueAction> createActions(Issue var1, ApplicationUser var2, boolean var3);

    protected abstract boolean isShowPanel(Issue var1, ApplicationUser var2);
}

