/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.errorbeans;

import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.stash.IntegrationProblem;

public class RepositoryErrorBean {
    private final String rep;
    private final String instance;
    private final String error;

    public RepositoryErrorBean(SourceErrorReport rer) {
        this.rep = rer.getRepositoryName();
        this.instance = rer.getUrl();
        this.error = rer.getErrorMessage();
    }

    public RepositoryErrorBean(IntegrationProblem stashError) {
        this.rep = null;
        this.instance = stashError.getApplicationLink().getDisplayUrl().toASCIIString();
        this.error = stashError.getMessage();
    }

    public String getRep() {
        return this.rep;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return "RepositoryErrorBean{rep='" + this.rep + '\'' + ", instance='" + this.instance + '\'' + ", error='" + this.error + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryErrorBean that = (RepositoryErrorBean)o;
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.instance != null ? !this.instance.equals(that.instance) : that.instance != null) {
            return false;
        }
        return !(this.rep != null ? !this.rep.equals(that.rep) : that.rep != null);
    }

    public int hashCode() {
        int result = this.rep != null ? this.rep.hashCode() : 0;
        result = 31 * result + (this.instance != null ? this.instance.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }
}

