/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.errorbeans;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jirafisheyeplugin.domain.fisheye.OAuthErrorReport;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class OAuthErrorBean {
    private final ApplicationId applicationId;
    private final URI authURI;
    private final String serverName;
    private final String serverURL;
    private final ImmutableSet<String> repositoryNames;
    private final boolean hideable;

    public OAuthErrorBean(URI authURI, Collection<OAuthErrorReport> errorReports) {
        this.authURI = (URI)Preconditions.checkNotNull((Object)authURI);
        this.repositoryNames = this.getNonBlankRepositoryNames(errorReports);
        if (errorReports.isEmpty()) {
            throw new IllegalArgumentException("Can't construct OAuthErrorBean with no OAuthErrorReports");
        }
        OAuthErrorReport exemplar = errorReports.iterator().next();
        this.serverName = exemplar.getName();
        this.serverURL = exemplar.getUrl();
        this.applicationId = exemplar.getApplicationId();
        this.hideable = exemplar.isHideable();
    }

    protected OAuthErrorBean(ApplicationId applicationId, URI authURI, String serverName, String serverURL, Iterable<String> repositoryNames) {
        this.applicationId = applicationId;
        this.authURI = authURI;
        this.serverName = serverName;
        this.serverURL = serverURL;
        this.repositoryNames = ImmutableSet.copyOf(repositoryNames);
        this.hideable = true;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getAuthorizationURI() {
        return this.authURI.toString();
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerNameAsHtml() {
        return this.getServerName() != null ? StringEscapeUtils.escapeHtml(this.getServerName()) : null;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getServerURLAsHtml() {
        return this.getServerURL() != null ? StringEscapeUtils.escapeHtml(this.getServerURL()) : null;
    }

    public ImmutableSet<String> getRepositories() {
        return this.repositoryNames;
    }

    public ImmutableSet<String> getRepositoriesAsHtml() {
        return ImmutableSet.copyOf((Iterable)Collections2.transform(this.getRepositories(), (Function)new HtmlEscape()));
    }

    private ImmutableSet<String> getNonBlankRepositoryNames(Iterable<OAuthErrorReport> errorReports) {
        ArrayList nonEmptyNames = Lists.newArrayList();
        for (OAuthErrorReport errorReport : errorReports) {
            String repoName = errorReport.getRepositoryName();
            if (StringUtils.isBlank(repoName)) continue;
            nonEmptyNames.add(repoName);
        }
        return ImmutableSet.copyOf((Iterable)nonEmptyNames);
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthErrorBean that = (OAuthErrorBean)o;
        if (!this.authURI.equals(that.authURI)) {
            return false;
        }
        if (!this.repositoryNames.equals(that.repositoryNames)) {
            return false;
        }
        if (!this.serverName.equals(that.serverName)) {
            return false;
        }
        return this.serverURL.equals(that.serverURL);
    }

    public int hashCode() {
        int result = this.authURI.hashCode();
        result = 31 * result + this.serverName.hashCode();
        result = 31 * result + this.serverURL.hashCode();
        result = 31 * result + this.repositoryNames.hashCode();
        return result;
    }

    public String toString() {
        return "OAuthErrorBean{authURI=" + this.authURI + ", serverName='" + this.serverName + '\'' + ", serverURL='" + this.serverURL + '\'' + ", repositoryNames=" + this.repositoryNames + '}';
    }

    private static class HtmlEscape
    implements Function<String, String> {
        private HtmlEscape() {
        }

        public String apply(String from) {
            return StringEscapeUtils.escapeHtml(from);
        }
    }
}

