/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.errorbeans;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jirafisheyeplugin.domain.fisheye.OAuthErrorReport;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.stash.CredentialsRequest;
import com.atlassian.jirafisheyeplugin.stash.IntegrationProblem;
import com.atlassian.jirafisheyeplugin.web.errorbeans.OAuthErrorBean;
import com.atlassian.jirafisheyeplugin.web.errorbeans.RepositoryErrorBean;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(ErrorBeanUtils.class);
    private final JiraAuthenticationContext authenticationContext;

    public ErrorBeanUtils(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public List<RepositoryErrorBean> extractNonOAuthErrors(Collection<SourceErrorReport> repositoryErrors) {
        return this.extractNonOAuthErrors(repositoryErrors, Collections.emptyList());
    }

    public List<RepositoryErrorBean> extractNonOAuthErrors(Collection<SourceErrorReport> repositoryErrors, Collection<IntegrationProblem> stashErrors) {
        ArrayList nonOAuthErrorBeans = Lists.newArrayListWithCapacity((int)repositoryErrors.size());
        for (SourceErrorReport repositoryError : repositoryErrors) {
            if (repositoryError instanceof OAuthErrorReport) continue;
            nonOAuthErrorBeans.add(new RepositoryErrorBean(repositoryError));
        }
        for (IntegrationProblem stashError : stashErrors) {
            nonOAuthErrorBeans.add(new RepositoryErrorBean(stashError));
        }
        return nonOAuthErrorBeans;
    }

    public List<OAuthErrorBean> extractOAuthErrors(Collection<SourceErrorReport> repositoryErrors, URI callbackURI) {
        return this.extractOAuthErrors(repositoryErrors, Collections.emptyList(), callbackURI);
    }

    public List<OAuthErrorBean> extractOAuthErrors(Collection<SourceErrorReport> repositoryErrors, Collection<CredentialsRequest> credentialsRequests, URI callbackURI) {
        Set<ApplicationId> ignoredApplicationLinks = this.resolveIgnoredApplicationLinksForUser();
        HashMultimap oAuthErrorMap = HashMultimap.create();
        for (SourceErrorReport repositoryError : repositoryErrors) {
            OAuthErrorReport oAuthError;
            if (!(repositoryError instanceof OAuthErrorReport) || ignoredApplicationLinks.contains((oAuthError = (OAuthErrorReport)repositoryError).getApplicationId())) continue;
            oAuthErrorMap.put((Object)oAuthError.getAuthorisationURI(callbackURI), (Object)oAuthError);
        }
        for (CredentialsRequest credentialsRequest : credentialsRequests) {
            oAuthErrorMap.put((Object)credentialsRequest.getAuthorisationURIGenerator().getAuthorisationURI(callbackURI), (Object)new OAuthErrorReport(credentialsRequest.getApplicationLink(), credentialsRequest.getAuthorisationURIGenerator(), "Credentials Required"));
        }
        ArrayList oAuthErrorBeans = Lists.newArrayListWithCapacity((int)repositoryErrors.size());
        for (Map.Entry repositoryError : oAuthErrorMap.asMap().entrySet()) {
            Collection oAuthError = (Collection)repositoryError.getValue();
            oAuthErrorBeans.add(new OAuthErrorBean((URI)repositoryError.getKey(), oAuthError));
        }
        return oAuthErrorBeans;
    }

    public Set<ApplicationId> resolveIgnoredApplicationLinksForUser() {
        HashSet ignoredApplicationLinks = Sets.newHashSet();
        HttpServletRequest req = ExecutingHttpRequest.get();
        if (req != null) {
            String cookieName = this.cookieName();
            for (Cookie cookie : ErrorBeanUtils.emptyIfNull(req.getCookies())) {
                if (!cookieName.equals(cookie.getName())) continue;
                String ignoredString = cookie.getValue();
                if (ignoredString == null) break;
                for (String id : ignoredString.split("\\|")) {
                    try {
                        ignoredApplicationLinks.add(new ApplicationId(id));
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Invalid application link id stored in ignoredAppLinks cookie: " + id);
                    }
                }
                break;
            }
        }
        return ignoredApplicationLinks;
    }

    private static Cookie[] emptyIfNull(Cookie[] iterable) {
        return iterable == null ? new Cookie[]{} : iterable;
    }

    private String cookieName() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return "JFEP.ignoredAppLinks." + (user == null ? "__ANON" : user.getKey());
    }
}

