/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.charts.jfreechart;

import java.util.ArrayList;
import java.util.Collections;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class DatasetUtils {
    public static PieDataset createConsolidatedSortedPieDataset(PieDataset source, Comparable otherKey, boolean sort, double minimumPercent, int minItems) {
        if (sort) {
            source = DatasetUtils.createSortedPieDataset(source);
        }
        if (minItems < source.getKeys().size()) {
            return DatasetUtils.removeZeroOthers(otherKey, DatasetUtilities.createConsolidatedPieDataset((PieDataset)source, (Comparable)otherKey, (double)minimumPercent, (int)0));
        }
        return source;
    }

    private static PieDataset removeZeroOthers(Comparable otherKey, PieDataset d) {
        if (d.getValue(otherKey).doubleValue() == 0.0) {
            DefaultPieDataset result = new DefaultPieDataset();
            for (Object o : d.getKeys()) {
                Comparable c = (Comparable)o;
                if (otherKey.equals(c)) continue;
                result.setValue(c, d.getValue(c));
            }
            return result;
        }
        return d;
    }

    public static PieDataset createSortedPieDataset(PieDataset source) {
        ArrayList<SortableItem> items = new ArrayList<SortableItem>(source.getItemCount());
        for (Comparable key : source.getKeys()) {
            Number dataValue = source.getValue(key);
            items.add(new SortableItem(key, dataValue));
        }
        Collections.sort(items);
        Collections.reverse(items);
        DefaultPieDataset sortedDataset = new DefaultPieDataset();
        for (SortableItem sortableItem : items) {
            sortedDataset.setValue(sortableItem.key, sortableItem.value);
        }
        return sortedDataset;
    }

    private static class SortableItem
    implements Comparable {
        private Comparable key;
        private Number value;

        public SortableItem(Comparable key, Number value) {
            this.key = key;
            this.value = value;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            Number n = ((SortableItem)o).value;
            if (this.value.doubleValue() > n.doubleValue()) {
                return 1;
            }
            if (this.value.doubleValue() < n.doubleValue()) {
                return -1;
            }
            return 0;
        }
    }
}

