/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.charts.jfreechart;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jirafisheyeplugin.web.charts.jfreechart.ChartHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartUtils {
    private static Logger log = LoggerFactory.getLogger(ChartUtils.class);
    public static final int PORTLET_IMAGE_HEIGHT = 300;
    public static final int PORTLET_IMAGE_WIDTH = 450;
    public static final int REPORT_IMAGE_HEIGHT = 500;
    public static final int REPORT_IMAGE_WIDTH = 800;
    public static final Color COLOR_RED_OUTLINE = new Color(204, 0, 0);
    public static final Color COLOR_RED_PAINT = new Color(255, 204, 204);
    public static final Color COLOR_BLUE_OUTLINE = new Color(0, 0, 204);
    public static final Color COLOR_BLUE_PAINT = new Color(204, 204, 255);
    public static final Color COLOR_GREEN_OUTLINE = new Color(0, 204, 0);
    public static final Color COLOR_GREEN_PAINT = new Color(204, 255, 204);
    public static final Color COLOR_YELLOW_OUTLINE = new Color(204, 204, 0);
    public static final Color COLOR_YELLOW_PAINT = new Color(255, 255, 204);
    public static final Color COLOR_PURPLE_OUTLINE = new Color(204, 0, 204);
    public static final Color COLOR_PURPLE_PAINT = new Color(255, 204, 255);
    public static final Color COLOR_CYAN_OUTLINE = new Color(0, 204, 204);
    public static final Color COLOR_CYAN_PAINT = new Color(204, 255, 255);
    public static final Color COLOR_ORANGE_PAINT = new Color(255, 230, 204);
    private static final Color[][] PIE_SEGMENT_COLOURS = new Color[][]{{COLOR_RED_OUTLINE, COLOR_RED_PAINT}, {COLOR_BLUE_OUTLINE, COLOR_BLUE_PAINT}, {COLOR_GREEN_OUTLINE, COLOR_GREEN_PAINT}, {COLOR_YELLOW_OUTLINE, COLOR_YELLOW_PAINT}, {COLOR_RED_OUTLINE, COLOR_ORANGE_PAINT}, {COLOR_PURPLE_OUTLINE, COLOR_PURPLE_PAINT}, {COLOR_CYAN_OUTLINE, COLOR_CYAN_PAINT}, {COLOR_BLUE_OUTLINE, COLOR_BLUE_PAINT}, {COLOR_GREEN_OUTLINE, COLOR_GREEN_PAINT}, {COLOR_YELLOW_OUTLINE, COLOR_YELLOW_PAINT}, {COLOR_RED_OUTLINE, COLOR_ORANGE_PAINT}, {COLOR_PURPLE_OUTLINE, COLOR_PURPLE_PAINT}, {COLOR_CYAN_OUTLINE, COLOR_CYAN_PAINT}, {COLOR_BLUE_OUTLINE, COLOR_BLUE_PAINT}};

    public static RegularTimePeriod createPeriod(Date date, String periodName) {
        Class timePeriodClass = ChartUtils.getTimePeriodClass(periodName);
        return RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)date, (TimeZone)RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public static Class getTimePeriodClass(String periodName) {
        if (periodName.equalsIgnoreCase("daily")) {
            return Day.class;
        }
        if (periodName.equalsIgnoreCase("hourly")) {
            return Hour.class;
        }
        if (periodName.equalsIgnoreCase("weekly")) {
            return Week.class;
        }
        if (periodName.equalsIgnoreCase("monthly")) {
            return Month.class;
        }
        if (periodName.equalsIgnoreCase("quarterly")) {
            return Quarter.class;
        }
        if (periodName.equalsIgnoreCase("yearly")) {
            return Year.class;
        }
        return Day.class;
    }

    public static String getTimePeriodi18nName(long timePeriodLength) {
        if (DateUtils.DAY_MILLIS == timePeriodLength) {
            return "datacollector.days";
        }
        if (DateUtils.HOUR_MILLIS == timePeriodLength) {
            return "datacollector.hours";
        }
        return "";
    }

    public static ChartHelper generateBarChart(CategoryDataset dataset, String chartTitle, String yLabel, String xLabel) {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createBarChart((String)chartTitle, (String)yLabel, (String)xLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        axis.setStandardTickUnits(units);
        plot.getRenderer().setSeriesOutlinePaint(0, (Paint)COLOR_GREEN_OUTLINE);
        plot.getRenderer().setSeriesPaint(0, (Paint)COLOR_GREEN_PAINT);
        return new ChartHelper(chart);
    }

    public static ChartHelper generateAreaChart(CategoryDataset dataset, String chartTitle, String yLabel, String xLabel) {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createAreaChart((String)chartTitle, (String)yLabel, (String)xLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        axis.setStandardTickUnits(units);
        AreaRenderer renderer = (AreaRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)COLOR_RED_PAINT);
        renderer.setSeriesOutlinePaint(0, (Paint)new Color(255, 0, 0));
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.0f));
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        return new ChartHelper(chart);
    }

    public static CategoryDataset getCategoryDataset(Map data, String seriesName) {
        return ChartUtils.getCategoryDataset(new Map[]{data}, new String[]{seriesName});
    }

    public static CategoryDataset getCategoryDataset(Map[] dataMaps, String[] seriesNames) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if (dataMaps.length != seriesNames.length) {
            throw new IllegalArgumentException("Number of datamaps and series names must be the equal.");
        }
        for (int i = 0; i < seriesNames.length; ++i) {
            String seriesName = seriesNames[i];
            Map data = dataMaps[i];
            for (RegularTimePeriod period : data.keySet()) {
                dataset.addValue((Number)data.get(period), (Comparable)((Object)seriesName), (Comparable)period);
            }
        }
        return dataset;
    }

    public static ChartHelper generateMultiLineChart(XYDataset dataset, String chartTitle, String yLabel, String xLabel, List domainMarkers) {
        XYItemRenderer plotRenderer;
        boolean legend = true;
        boolean tooltips = true;
        boolean urls = true;
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)yLabel, (String)xLabel, (XYDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        yAxis.setStandardTickUnits(units);
        if (domainMarkers != null && !domainMarkers.isEmpty()) {
            for (ValueMarker valueMarker : domainMarkers) {
                valueMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                valueMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                plot.addDomainMarker((Marker)valueMarker);
            }
        }
        if ((plotRenderer = plot.getRenderer()) instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plotRenderer;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
        }
        return new ChartHelper(chart);
    }

    public static ChartHelper generateTimeSeriesChart(XYDataset dataset, String chartTitle, String yLabel, String xLabel, List domainMarkers) {
        boolean legend = false;
        boolean tooltips = true;
        boolean urls = true;
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, (String)yLabel, (String)xLabel, (XYDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        yAxis.setStandardTickUnits(units);
        if (domainMarkers != null && !domainMarkers.isEmpty()) {
            for (ValueMarker valueMarker : domainMarkers) {
                valueMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                valueMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                plot.addDomainMarker((Marker)valueMarker);
            }
        }
        XYDifferenceRenderer xyDifferenceRenderer = new XYDifferenceRenderer((Paint)COLOR_RED_PAINT, (Paint)COLOR_GREEN_PAINT, true);
        xyDifferenceRenderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        xyDifferenceRenderer.setSeriesPaint(1, (Paint)new Color(51, 204, 51));
        xyDifferenceRenderer.setShape((Shape)new Ellipse2D.Double(-1.5, -1.5, 3.0, 3.0));
        plot.setRenderer((XYItemRenderer)xyDifferenceRenderer);
        return new ChartHelper(chart);
    }

    public static CategoryDataset reduceDataset(CategoryDataset dataset, List rowKeysToKeep) {
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        for (Comparable rowKey : rowKeysToKeep) {
            if (-1 == dataset.getRowIndex(rowKey)) continue;
            for (Comparable colKey : dataset.getColumnKeys()) {
                newDataset.addValue(dataset.getValue(rowKey, colKey), rowKey, colKey);
            }
        }
        return newDataset;
    }

    public static XYDataset generateTimeSeriesXYDataset(Map nameSeriesMap) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (String name : nameSeriesMap.keySet()) {
            Map seriesMap = (Map)nameSeriesMap.get(name);
            TimeSeries series = null;
            for (RegularTimePeriod period : seriesMap.keySet()) {
                if (series == null) {
                    series = new TimeSeries((Comparable)((Object)name), period.getClass());
                }
                series.add(period, (Number)seriesMap.get(period));
            }
            if (series == null) continue;
            dataset.addSeries(series);
        }
        return dataset;
    }

    public static XYDataset generateTimeSeriesXYDataset(String series1Name, Map series1Map, String series2Name, Map series2Map) {
        TimeSeries series1 = null;
        TimeSeries series2 = null;
        for (RegularTimePeriod period : series1Map.keySet()) {
            if (series1 == null) {
                series1 = new TimeSeries((Comparable)((Object)series1Name), period.getClass());
            }
            series1.add(period, (Number)series1Map.get(period));
        }
        for (RegularTimePeriod period : series2Map.keySet()) {
            if (series2 == null) {
                series2 = new TimeSeries((Comparable)((Object)series2Name), period.getClass());
            }
            series2.add(period, (Number)series2Map.get(period));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        return dataset;
    }

    public static ChartHelper generateStackedBarChart(CategoryDataset dataset, String chartTitle, String yLabel, String xLabel, List domainMarkers) {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createStackedBarChart((String)chartTitle, (String)yLabel, (String)xLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        axis.setStandardTickUnits(units);
        plot.getRenderer().setSeriesOutlinePaint(1, (Paint)COLOR_YELLOW_OUTLINE);
        plot.getRenderer().setSeriesPaint(1, (Paint)COLOR_YELLOW_PAINT);
        plot.getRenderer().setSeriesOutlinePaint(0, (Paint)COLOR_CYAN_OUTLINE);
        plot.getRenderer().setSeriesPaint(0, (Paint)COLOR_CYAN_PAINT);
        return new ChartHelper(chart);
    }

    public static ChartHelper generatePieChart(PieDataset dataset, String chartTitle) {
        return ChartUtils.generatePieChart(dataset, chartTitle, PIE_SEGMENT_COLOURS);
    }

    public static ChartHelper generatePieChart(PieDataset dataset, String chartTitle, Color[][] colorScheme) {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setOutlinePaint(null);
        for (int i = 0; i < colorScheme.length; ++i) {
            ChartUtils.setSectionColor(dataset, plot, i, colorScheme[i][0], colorScheme[i][1]);
        }
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        return new ChartHelper(chart);
    }

    private static void setSectionColor(PieDataset dataset, PiePlot plot, int section, Color outline, Color paint) {
        try {
            Comparable key = dataset.getKey(section);
            plot.setSectionOutlinePaint(key, (Paint)outline);
            plot.setSectionPaint(key, (Paint)paint);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

