/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.charts.jfreechart;

import com.atlassian.core.util.RandomGenerator;
import com.atlassian.jirafisheyeplugin.exceptions.AlreadyGeneratedException;
import java.io.IOException;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.servlet.ServletUtilities;

public class ChartHelper {
    private JFreeChart chart;
    private boolean generated = false;
    private ChartRenderingInfo renderingInfo = null;
    private String location = null;
    private String imageMap;
    private String imageMapName;

    public ChartHelper(JFreeChart chart) {
        this.chart = chart;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void generate(int width, int height) throws IOException, AlreadyGeneratedException {
        if (this.generated) {
            throw new AlreadyGeneratedException();
        }
        this.renderingInfo = new ChartRenderingInfo();
        this.location = ServletUtilities.saveChartAsPNG((JFreeChart)this.chart, (int)width, (int)height, (ChartRenderingInfo)this.renderingInfo, null);
        this.generated = true;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public ChartRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    public String getLocation() {
        return this.location;
    }

    public String getImageMap() {
        if (this.imageMap == null && this.generated) {
            this.imageMapName = "chart-" + RandomGenerator.randomString((int)5);
            this.imageMap = ChartUtilities.getImageMap((String)this.imageMapName, (ChartRenderingInfo)this.renderingInfo);
        }
        return this.imageMap;
    }

    public String getImageMapName() {
        return this.imageMapName;
    }
}

