/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.charts;

import com.atlassian.jirafisheyeplugin.exceptions.AlreadyGeneratedException;
import com.atlassian.jirafisheyeplugin.web.charts.FishEyeChartManager;
import com.atlassian.jirafisheyeplugin.web.charts.jfreechart.ChartHelper;
import com.atlassian.jirafisheyeplugin.web.charts.jfreechart.ChartUtils;
import com.atlassian.jirafisheyeplugin.web.charts.jfreechart.DatasetUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeChartManagerImpl
implements FishEyeChartManager {
    private static Logger log = LoggerFactory.getLogger(FishEyeChartManagerImpl.class);
    private static final Color[][] CRU_PIE_COLORS = new Color[][]{{ChartUtils.COLOR_BLUE_OUTLINE, ChartUtils.COLOR_BLUE_PAINT}, {ChartUtils.COLOR_RED_OUTLINE, ChartUtils.COLOR_RED_PAINT}};
    private static final int FE_PIE_WIDTH = 320;
    private static final int FE_PIE_HEIGHT = 180;
    private static final int CRU_PIE_WIDTH = 260;
    private static final int CRU_PIE_HEIGHT = 250;
    private static final int BAR_WIDTH = 440;
    private static final int BAR_HEIGHT = 170;

    @Override
    public Map<String, String> generatePieChart(Map<String, Integer> keyIntValueMap, String velocityContextKey) {
        return this.generatePieChart(keyIntValueMap, velocityContextKey, null);
    }

    @Override
    public Map<String, String> generatePieChart(Map<String, Integer> keyIntValueMap, String velocityContextKey, PieURLGenerator urlGenerator) {
        return this.generatePieChart(keyIntValueMap, velocityContextKey, urlGenerator, 1);
    }

    @Override
    public Map<String, String> generatePieChart(Map<String, Integer> keyIntValueMap, String velocityContextKey, PieURLGenerator urlGenerator, int chartType) {
        ChartHelper helper;
        int total = 0;
        DefaultKeyedValues kv = new DefaultKeyedValues();
        for (Map.Entry<String, Integer> stringIntegerEntry : keyIntValueMap.entrySet()) {
            String key = stringIntegerEntry.getKey();
            int entryValue = stringIntegerEntry.getValue();
            kv.setValue((Comparable)((Object)key), (double)entryValue);
            total += entryValue;
        }
        DefaultPieDataset dataset = new DefaultPieDataset((KeyedValues)kv);
        PieDataset sortedDataset = DatasetUtils.createSortedPieDataset((PieDataset)dataset);
        PieDataset consolidatedDataset = DatasetUtils.createConsolidatedSortedPieDataset(sortedDataset, (Comparable)((Object)"other"), false, 0.02, 2);
        final int totalCopy = total;
        switch (chartType) {
            case 1: {
                helper = ChartUtils.generatePieChart(consolidatedDataset, null);
                break;
            }
            case 2: {
                helper = ChartUtils.generatePieChart(consolidatedDataset, null, CRU_PIE_COLORS);
                break;
            }
            default: {
                helper = ChartUtils.generatePieChart(consolidatedDataset, null);
            }
        }
        JFreeChart chart = helper.getChart();
        PiePlot plot = (PiePlot)chart.getPlot();
        this.initPlot(plot, chartType);
        plot.setToolTipGenerator(new PieToolTipGenerator(){

            public String generateToolTip(PieDataset dataset, Comparable key) {
                Number number = dataset.getValue(key);
                return key + ": " + number.intValue() + " (" + 100 * number.intValue() / totalCopy + "%)";
            }
        });
        if (urlGenerator != null) {
            plot.setURLGenerator(urlGenerator);
        }
        try {
            switch (chartType) {
                case 1: {
                    helper.generate(320, 180);
                    break;
                }
                case 2: {
                    helper.generate(260, 250);
                    break;
                }
                default: {
                    helper.generate(320, 180);
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error("Error generating pie chart", (Throwable)e);
        }
        catch (AlreadyGeneratedException e) {
            // empty catch block
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(velocityContextKey + "chart", helper.getLocation());
        params.put(velocityContextKey + "imagemap", helper.getImageMap());
        params.put(velocityContextKey + "imagemapName", helper.getImageMapName());
        return params;
    }

    private void initPlot(PiePlot plot, int chartType) {
        switch (chartType) {
            case 1: {
                plot.setStartAngle(180.0);
                plot.setDirection(Rotation.ANTICLOCKWISE);
                break;
            }
            case 2: {
                plot.setStartAngle(160.0);
                plot.setDirection(Rotation.CLOCKWISE);
                plot.setExplodePercent((Comparable)((Object)"Unreviewed"), 0.25);
                plot.setLabelGenerator(null);
                break;
            }
        }
    }

    @Override
    public Map<String, String> generateColumnChart(Map<String, Integer> positiveValues, Map<String, Integer> negativeValues, String velocityContextKey, String positiveTooltipSuffix, String negativeTooltipSuffix) {
        return this.generateColumnChart(positiveValues, negativeValues, velocityContextKey, positiveTooltipSuffix, negativeTooltipSuffix, null);
    }

    @Override
    public Map<String, String> generateColumnChart(Map<String, Integer> positiveValues, Map<String, Integer> negativeValues, String velocityContextKey, final String positiveTooltipSuffix, final String negativeTooltipSuffix, CategoryURLGenerator urlGenerator) {
        Number number;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<String, Integer> entry : positiveValues.entrySet()) {
            number = entry.getValue();
            dataset.addValue(number, (Comparable)((Object)"pos"), (Comparable)((Object)entry.getKey()));
        }
        for (Map.Entry<String, Integer> entry : negativeValues.entrySet()) {
            number = entry.getValue();
            if (number.intValue() == 0) continue;
            dataset.addValue(number, (Comparable)((Object)"neg"), (Comparable)((Object)entry.getKey()));
        }
        ChartHelper helper = ChartUtils.generateStackedBarChart((CategoryDataset)dataset, null, null, null, null);
        CategoryPlot plot = helper.getChart().getCategoryPlot();
        plot.getDomainAxis().setVisible(false);
        if (urlGenerator != null) {
            plot.getRenderer().setItemURLGenerator(urlGenerator);
        }
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                Number value = dataset.getValue(row, column);
                String date = (String)((Object)dataset.getColumnKey(column));
                return date + ": " + Math.abs(value.intValue()) + " " + (row == 0 ? positiveTooltipSuffix : negativeTooltipSuffix);
            }
        });
        try {
            helper.generate(440, 170);
        }
        catch (IOException e) {
            log.error("Error generating pie chart", (Throwable)e);
        }
        catch (AlreadyGeneratedException e) {
            // empty catch block
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(velocityContextKey + "chart", helper.getLocation());
        params.put(velocityContextKey + "imagemap", helper.getImageMap());
        params.put(velocityContextKey + "imagemapName", helper.getImageMapName());
        return params;
    }

    @Override
    public Map<String, String> generateColumnChart(Map<String, Integer> valueMap, String velocityContextKey, String tooltipSuffix) {
        return this.generateColumnChart(valueMap, velocityContextKey, tooltipSuffix, null);
    }

    @Override
    public Map<String, String> generateColumnChart(Map<String, Integer> valueMap, String velocityContextKey, final String tooltipSuffix, CategoryURLGenerator urlGenerator) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<String, Integer> entry : valueMap.entrySet()) {
            Number number = entry.getValue();
            dataset.addValue(number, (Comparable)((Object)"pos"), (Comparable)((Object)entry.getKey()));
        }
        ChartHelper helper = ChartUtils.generateBarChart((CategoryDataset)dataset, null, null, null);
        CategoryPlot plot = (CategoryPlot)helper.getChart().getPlot();
        plot.getDomainAxis().setVisible(false);
        if (urlGenerator != null) {
            plot.getRenderer().setItemURLGenerator(urlGenerator);
        }
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                Number value = dataset.getValue(row, column);
                String date = (String)((Object)dataset.getColumnKey(column));
                return date + ": " + Math.abs(value.intValue()) + " " + tooltipSuffix;
            }
        });
        try {
            helper.generate(440, 170);
        }
        catch (IOException e) {
            log.error("Error generating pie chart:", (Throwable)e);
        }
        catch (AlreadyGeneratedException e) {
            // empty catch block
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(velocityContextKey + "chart", helper.getLocation());
        params.put(velocityContextKey + "imagemap", helper.getImageMap());
        params.put(velocityContextKey + "imagemapName", helper.getImageMapName());
        return params;
    }
}

