/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.admin.perforce.P4ErrorParser;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.perforce.api.PerforceException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ViewPerforceConfiguration
extends BaseAdminAction {
    private PerforceConfigStore p4ConfigStore;
    private PerforceManager perforceManager;
    private FishEyeConfig fisheyeConfig;
    private Boolean isFishEyeConfigInvalid;
    private Integer newDefault;
    private Integer testId;
    private final Map<Integer, TestReport> testResults = new HashMap<Integer, TestReport>();

    public ViewPerforceConfiguration(PerforceConfigStore p4ConfigStore, PerforceManager perforceManager, FishEyeConfig fisheyeConfig, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.p4ConfigStore = p4ConfigStore;
        this.perforceManager = perforceManager;
        this.fisheyeConfig = fisheyeConfig;
    }

    public String doDefault() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (!this.fisheyeConfig.isValid()) {
            this.isFishEyeConfigInvalid = Boolean.TRUE;
            return "error";
        }
        return "success";
    }

    protected String doExecute() throws Exception {
        PerforceConfig p4cfg;
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.getNewDefault() != null) {
            p4cfg = this.p4ConfigStore.getConfig(this.getNewDefault());
            if (p4cfg != null) {
                this.p4ConfigStore.setDefaultConfig(this.newDefault);
            } else {
                this.log.error("Couldn't set default as Perforce config with id '" + this.getTestId() + "', couldn't find config with that id.");
            }
        }
        if (this.getTestId() != null) {
            p4cfg = this.p4ConfigStore.getConfig(this.getTestId());
            if (p4cfg != null) {
                this.testConfiguration(p4cfg);
            } else {
                this.log.error("Couldn't test connection for Perforce config with id '" + this.getTestId() + "', couldn't find config with that id.");
            }
        }
        return "success";
    }

    public PerforceConfig getDefaultConfig() {
        return this.p4ConfigStore.getDefaultConfig();
    }

    public List getNonDefaultConfigs() {
        List<PerforceConfig> configs = this.p4ConfigStore.getAllConfigs();
        configs.remove(this.p4ConfigStore.getDefaultConfig());
        return configs;
    }

    public Integer getNewDefault() {
        return this.newDefault;
    }

    public void setNewDefault(Integer newDefault) {
        this.newDefault = newDefault;
    }

    public Collection getProjects(PerforceConfig cfg) {
        return this.p4ConfigStore.getAssociatedProjects(cfg);
    }

    private void testConfiguration(PerforceConfig config) throws Exception {
        boolean success;
        String error = null;
        String suggestion = null;
        try {
            this.perforceManager.testConnection(config);
            success = true;
        }
        catch (Exception e) {
            if (e instanceof PerforceException || e instanceof IOException) {
                success = false;
                error = this.getDescriptiveExceptionMessage(e);
                String suggestionKey = P4ErrorParser.getSuggestionKey(e);
                if (suggestionKey != null) {
                    suggestion = this.getText(suggestionKey);
                }
                this.log.error(this.getText("fisheye.config.error.p4.connection.problem"), (Throwable)e);
            }
            throw e;
        }
        this.testResults.put(config.getId(), new TestReport(success, error, suggestion));
    }

    private String getDescriptiveExceptionMessage(Throwable e) {
        return this.getDescriptiveExceptionMessageHelper(e).trim();
    }

    private String getDescriptiveExceptionMessageHelper(Throwable e) {
        return e.getCause() != null ? e.toString() + " " + this.getDescriptiveExceptionMessageHelper(e.getCause()) : e.toString();
    }

    public Integer getTestId() {
        return this.testId;
    }

    public void setTestId(Integer testId) {
        this.testId = testId;
    }

    public TestReport getTestReport(Integer id) {
        return this.testResults.get(id);
    }

    public Boolean isFishEyeConfigInvalid() {
        return this.isFishEyeConfigInvalid;
    }

    public String getPasswordPlaceholder() {
        return "********";
    }

    public static class TestReport {
        private boolean success;
        private String errorMessage;
        private String suggestion;

        public TestReport(boolean success, String errorMessage, String suggestion) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.suggestion = suggestion;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getSuggestion() {
            return this.suggestion;
        }
    }
}

