/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import java.util.HashMap;
import java.util.Map;

public class P4ErrorParser {
    private static P4ErrorParser instance;
    private Map<String, String> stacktrace2suggestion = new HashMap<String, String>();

    private P4ErrorParser() {
        this.stacktrace2suggestion.put("Invalid Perforce config", "p4.error.invalid.config");
        this.stacktrace2suggestion.put("Can't create a new user", "p4.error.can.not.create.user");
        this.stacktrace2suggestion.put("WSAECONNREFUSED", "p4.error.wrong.port");
        this.stacktrace2suggestion.put("service unknown", "p4.error.bad.port.or.host");
        this.stacktrace2suggestion.put("host unknown", "p4.error.bad.port.or.system.root");
        this.stacktrace2suggestion.put("CreateProcess", "p4.error.bad.path.to.executable");
        this.stacktrace2suggestion.put("Perforce password (P4PASSWD) invalid or unset.", "p4.error.bad.password.or.ticketfile");
        this.stacktrace2suggestion.put("Unicode clients require a unicode enabled server.", "p4.error.not.unicode.server");
        this.stacktrace2suggestion.put("Unknown field name", "p4.error.jobspec.missing.field");
        this.stacktrace2suggestion.put("Missing required field", "p4.error.jira.missing.jobspec.required.field");
        this.stacktrace2suggestion.put("Failed to create Perforce job", "p4.error.check.charset");
    }

    private String getSuggestionHelper(Throwable e) {
        for (Map.Entry<String, String> entry : this.stacktrace2suggestion.entrySet()) {
            if (!this.containsString(e, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean containsString(Throwable e, String target) {
        return e.toString().indexOf(target) > -1 || e.getCause() != null && this.containsString(e.getCause(), target);
    }

    private static P4ErrorParser getInstance() {
        if (instance == null) {
            instance = new P4ErrorParser();
        }
        return instance;
    }

    public static String getSuggestionKey(Throwable e) {
        return P4ErrorParser.getInstance().getSuggestionHelper(e);
    }
}

