/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MapCustomFieldsToPerforce
extends BaseAdminAction {
    private PermissionManager permissionManager;
    private CustomFieldManager customFieldManager;
    private PerforceConfigStore perforceConfigStore;
    private Integer id;

    public MapCustomFieldsToPerforce(PermissionManager permissionManager, CustomFieldManager customFieldManager, PerforceConfigStore perforceConfigStore, JiraAuthenticationContext authenticationContext, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.permissionManager = permissionManager;
        this.customFieldManager = customFieldManager;
        this.perforceConfigStore = perforceConfigStore;
    }

    protected void validate() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("perforce.custom.fields.id.required"));
        } else if (this.perforceConfigStore.getConfig(this.id) == null) {
            this.addErrorMessage(this.getText("perforce.custom.fields.id.invalid"));
        }
    }

    public String doDefault() {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        this.validate();
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    @RequiresXsrfCheck
    public String doExecute() {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        Map newCfMap = this.constructValuelessCustomFieldIdMap();
        this.updateCustomFieldMapFromRequest(newCfMap);
        this.removeUnmappedCustomFields(newCfMap);
        this.storeCustomP4FieldMappings(newCfMap);
        return this.getRedirect("ViewPerforceConfig!default.jspa");
    }

    private void removeUnmappedCustomFields(Map cfMap) {
        Iterator iterator = cfMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            if (e.getKey() != null && e.getValue() != null) continue;
            iterator.remove();
        }
    }

    private void storeCustomP4FieldMappings(Map cfMap) {
        this.perforceConfigStore.setCustomFieldMap(cfMap, this.id);
    }

    private void updateCustomFieldMapFromRequest(Map customFieldIdMap) {
        for (Map.Entry param : this.request.getParameterMap().entrySet()) {
            String value;
            String key = (String)param.getKey();
            if (!key.startsWith("cfmap_") || !TextUtils.stringSet((String)(value = ((String[])param.getValue())[0].trim()))) continue;
            try {
                Long cfId = new Long(key.substring(key.lastIndexOf("_") + 1));
                if (customFieldIdMap.containsKey(cfId)) {
                    customFieldIdMap.put(cfId, value);
                    continue;
                }
                throw new IllegalStateException("newCfMap did not contain custom field id=" + cfId);
            }
            catch (Exception e) {
                this.log.error("Failed to store [" + key + ":" + value + "] in newCfMap", (Throwable)e);
            }
        }
    }

    public Map getCustomFieldMappings() {
        Map idMappings = this.perforceConfigStore.getCustomFieldMap(this.id);
        Map cfIdMap = this.constructValuelessCustomFieldIdMap();
        for (Map.Entry e : idMappings.entrySet()) {
            if (!cfIdMap.containsKey(e.getKey())) {
                this.log.info("Could not find custom field with id='" + e.getKey() + ". Assume deleted, removing p4 field mapping.");
                continue;
            }
            cfIdMap.put(e.getKey(), e.getValue());
        }
        return this.toCustomFieldMap(cfIdMap);
    }

    public Map constructValuelessCustomFieldIdMap() {
        HashMap<Long, Object> cfMap = new HashMap<Long, Object>();
        List fields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField cf : fields) {
            cfMap.put(cf.getIdAsLong(), null);
        }
        return cfMap;
    }

    private Map toCustomFieldMap(Map idMap) {
        HashMap map = new HashMap();
        for (Map.Entry e : idMap.entrySet()) {
            Long id = (Long)e.getKey();
            map.put(this.customFieldManager.getCustomFieldObject(id), e.getValue());
        }
        return map;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

