/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigImpl;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.util.ResourceUtil;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.admin.perforce.P4ErrorParser;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.opensymphony.util.TextUtils;
import com.perforce.api.PerforceException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import webwork.action.ResultException;

public class EditPerforceConfiguration
extends BaseAdminAction
implements FishEyePropertyKeys {
    private Integer id;
    private PerforceConfigStore perforceConfigStore;
    private PerforceManager perforceManager;
    private final PerforceProperties perforceProperties;
    private final JiraHome jiraHome;
    private final AttachmentPathManager attachmentPathManager;
    private String testP4Error;
    private String testP4Suggestion;
    private String client;
    private String executable;
    private String password;
    private String port;
    private String timeout;
    private String user;
    private String charset;
    private String ticketfile;
    private String logLevel;
    private String sysDrive;
    private String sysRoot;
    private String urlViewJob;
    private Boolean skipTest;

    public EditPerforceConfiguration(PerforceConfigStore perforceConfigStore, PerforceManager perforceManager, JiraAuthenticationContext authenticationContext, PerforceProperties perforceProperties, JiraHome jiraHome, AttachmentPathManager attachmentPathManager, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.perforceConfigStore = perforceConfigStore;
        this.perforceManager = perforceManager;
        this.perforceProperties = perforceProperties;
        this.jiraHome = jiraHome;
        this.attachmentPathManager = attachmentPathManager;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        HashMap<String, String> storedCustomFieldMappings = null;
        if (this.id != null) {
            storedCustomFieldMappings = this.perforceConfigStore.getCustomFieldMap(this.id);
        }
        if (storedCustomFieldMappings == null) {
            storedCustomFieldMappings = new HashMap<String, String>();
        }
        PerforceConfigImpl config = new PerforceConfigImpl(this.id, this.port, this.executable, this.user, this.password, this.client, this.isSet(this.timeout) ? new Long(this.timeout) : null, this.charset, this.ticketfile, this.logLevel, this.sysDrive, this.sysRoot, this.urlViewJob, storedCustomFieldMappings, this.jiraHome, this.perforceProperties, this.attachmentPathManager);
        if (this.getSkipTest() != null && this.getSkipTest().booleanValue()) {
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.perforceConfigStore.saveConfig(config);
            return this.getRedirect("ViewPerforceConfig!default.jspa");
        }
        boolean connectionError = false;
        try {
            this.perforceManager.testConnection(config);
        }
        catch (Exception e) {
            if (e instanceof PerforceException || e instanceof IOException) {
                connectionError = true;
                this.testP4Error = this.getDescriptiveExceptionMessage(e);
                String suggestionKey = P4ErrorParser.getSuggestionKey(e);
                if (suggestionKey != null) {
                    this.testP4Suggestion = this.getText(suggestionKey);
                }
                this.log.error(this.getText("fisheye.config.error.p4.connection.problem"), (Throwable)e);
            }
            throw e;
        }
        if (connectionError || this.hasAnyErrors()) {
            return "error";
        }
        this.perforceConfigStore.saveConfig(config);
        return this.getRedirect("ViewPerforceConfig!default.jspa");
    }

    private String getDescriptiveExceptionMessage(Throwable e) {
        return this.getDescriptiveExceptionMessageHelper(e).trim();
    }

    private String getDescriptiveExceptionMessageHelper(Throwable e) {
        return e.getCause() != null ? e.toString() + " " + this.getDescriptiveExceptionMessageHelper(e.getCause()) : e.toString();
    }

    public String doDefault() {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        this.loadProperties(this.id);
        return "input";
    }

    private void loadProperties(Integer id) {
        PerforceConfig config = null;
        if (id != null) {
            config = this.perforceConfigStore.getConfig(id);
        }
        if (config == null) {
            config = this.perforceConfigStore.getDefaultConfig();
        } else {
            this.port = config.getPort();
            this.client = config.getClient();
            this.password = config.getPassword();
            this.user = config.getUser();
            this.urlViewJob = config.getUrlJobView();
            this.charset = config.getCharset();
            String string = this.timeout = config.getTimeout() != null ? config.getTimeout().toString() : null;
        }
        if (config != null) {
            this.executable = config.getExecutablePath();
            this.ticketfile = config.getTicketfile();
            this.logLevel = config.getLogLevel();
            this.sysDrive = config.getSysDrive();
            this.sysRoot = config.getSysRoot();
        }
    }

    protected void validate() throws ResultException {
        if (!this.isSet(this.executable)) {
            this.addError("fisheye.p4.text.executable", this.getText("fisheye.error.p4.executable.required"));
        } else if (!new File(this.executable).exists()) {
            this.addError("fisheye.p4.text.executable", this.getText("fisheye.error.file.not.found"));
        } else if (!this.perforceManager.isValidPerforceExecutable(this.executable)) {
            this.addError("fisheye.p4.text.executable", this.getText("fisheye.error.p4.executable.not.valid", !this.perforceProperties.isNetworkShareAllowed() ? this.getText("fisheye.error.p4.executable.network.path.not.allowed") : "", this.perforceManager.getValidExecutableNames().toString()));
        }
        if (!this.isSet(this.user)) {
            this.addError("fisheye.p4.user", this.getText("fisheye.error.p4.user.required"));
        }
        if (!this.isSet(this.port)) {
            this.addError("fisheye.p4.text.port", this.getText("fisheye.error.p4.port.required"));
        }
        if (this.isSet(this.ticketfile)) {
            boolean isOnClasspath = ResourceUtil.getResourceAsStream(this.ticketfile, this.getClass()) != null;
            boolean isOnFileSystem = new File(this.ticketfile).exists();
            if (!isOnClasspath && !isOnFileSystem) {
                this.addError("fisheye.p4.text.ticketfile", this.getText("fisheye.error.file.or.resource.not.found"));
            }
        }
        if (this.isSet(this.timeout)) {
            try {
                if (Integer.parseInt(this.timeout.trim()) < 0) {
                    this.addError("fisheye.p4.timeout", this.getText("fisheye.error.negative.number"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("fisheye.p4.timeout", this.getText("fisheye.error.invalid.number"));
            }
        }
    }

    protected boolean isSet(String fieldValue) {
        return TextUtils.stringSet((String)fieldValue) && fieldValue.trim().length() > 0;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getPassword() {
        return this.password != null ? "********" : null;
    }

    public void setPassword(String password) {
        if (!"********".equals(password)) {
            this.password = password;
        }
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getTicketfile() {
        return this.ticketfile;
    }

    public void setTicketfile(String ticketfile) {
        this.ticketfile = ticketfile;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isVerbose() {
        return "verbose".equals(this.logLevel);
    }

    public boolean isNone() {
        return "none".equals(this.logLevel);
    }

    public boolean isNotice() {
        return "notice".equals(this.logLevel);
    }

    public boolean isWarning() {
        return "warning".equals(this.logLevel);
    }

    public boolean isError() {
        return "error".equals(this.logLevel);
    }

    public boolean isNotSelected() {
        return !this.isVerbose() && !this.isNone() && !this.isNotice() && !this.isWarning() && !this.isError();
    }

    public String getSysDrive() {
        return this.sysDrive;
    }

    public void setSysDrive(String sysDrive) {
        this.sysDrive = sysDrive;
    }

    public String getSysRoot() {
        return this.sysRoot;
    }

    public void setSysRoot(String sysRoot) {
        this.sysRoot = sysRoot;
    }

    public String getUrlViewJob() {
        return this.urlViewJob;
    }

    public void setUrlViewJob(String urlViewJob) {
        this.urlViewJob = urlViewJob;
    }

    @HtmlSafe
    public String getTestP4Suggestion() {
        return this.testP4Suggestion;
    }

    public String getTestP4Error() {
        return this.testP4Error;
    }

    public Boolean getSkipTest() {
        return this.skipTest;
    }

    public void setSkipTest(Boolean skipTest) {
        this.skipTest = skipTest;
    }

    public List<String> getSupportedCharsets() {
        return Arrays.asList("none", "utf8", "utf8-bom", "iso8859-1", "shiftjis", "eucjp", "iso8859-15", "iso8859-5", "macosroman", "winansi", "koi8_r", "cp1251", "utf16", "utf16-nobom", "utf16le", "utf16le-bom", "utf16be", "utf16be-bom", "utf32", "utf32-nobom", "utf32le", "utf32le-bom", "utf32be", "utf32be-bom");
    }
}

