/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.NullPerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;

public class DeletePerforceConfiguration
extends BaseAdminAction {
    private Integer id;
    private PerforceConfigStore p4ConfigStore;
    private PerforceConfig config;

    public DeletePerforceConfiguration(PerforceConfigStore p4ConfigStore, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.p4ConfigStore = p4ConfigStore;
    }

    public String doDefault() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.id == null) {
            this.addErrorMessage(this.getText("perforce.config.delete.id.required"));
        } else if (NullPerforceConfig.ID.equals(this.id)) {
            this.addErrorMessage(this.getText("perforce.config.can.not.delete.null.instance"));
        } else {
            this.config = this.p4ConfigStore.getConfig(this.id);
            if (this.config == null) {
                this.addErrorMessage(this.getText("perforce.config.delete.not.found", this.id));
            } else if (this.config == this.p4ConfigStore.getDefaultConfig() && this.p4ConfigStore.getAllConfigs().size() > 1) {
                this.addErrorMessage(this.getText("perforce.config.delete.can.not.delete.default.while.aux.exist"));
            }
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.id == null) {
            this.addErrorMessage(this.getText("perforce.config.delete.id.required"));
            return "error";
        }
        this.config = this.p4ConfigStore.getConfig(this.id);
        if (this.config == null) {
            this.addErrorMessage(this.getText("perforce.config.delete.not.found", this.id));
            return "error";
        }
        this.p4ConfigStore.deleteConfig(this.id);
        return this.getRedirect("ViewPerforceConfig!default.jspa");
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PerforceConfig getConfig() {
        return this.config;
    }

    public String getAssociatedProjects() {
        Collection<String> projects = this.p4ConfigStore.getAssociatedProjects(this.config);
        if (!projects.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = projects.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                sb.append(key);
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }
}

