/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.perforce;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.web.admin.BaseProjectAdminAction;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import webwork.action.ResultException;

public class AssociatePerforceConfiguration
extends BaseProjectAdminAction {
    private PerforceConfigStore perforceConfigStore;
    private ProjectManager projectManager;
    private FishEyeProperties fisheyeProperties;
    private String projectKey;
    private Integer p4ConfigId;
    private Project project;
    private boolean alwaysCreateJobs;
    private Integer oldId;

    public AssociatePerforceConfiguration(PerforceConfigStore perforceConfigStore, PermissionManager permissionManager, ProjectManager projectManager, JiraAuthenticationContext authenticationContext, FishEyeProperties fishEyeProperties, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.perforceConfigStore = perforceConfigStore;
        this.projectManager = projectManager;
        this.fisheyeProperties = fishEyeProperties;
    }

    protected void validate() throws ResultException {
        if (this.projectKey == null) {
            this.addErrorMessage("associate.perforce.config.project.key.required");
            return;
        }
        this.project = this.projectManager.getProjectObjByKey(this.projectKey);
        if (this.project == null) {
            this.addErrorMessage("associate.perforce.config.project.key.invalid");
            return;
        }
    }

    public String doDefault() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.ofNullable(this.project));
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        this.validate();
        if (this.hasAnyErrors()) {
            return "error";
        }
        PerforceConfig oldConfig = this.perforceConfigStore.getConfig(this.project);
        if (oldConfig != null) {
            this.oldId = oldConfig.getId();
        }
        this.alwaysCreateJobs = this.fisheyeProperties.getCollection("fisheye.p4.always.create.jobs").contains(this.projectKey);
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.ofNullable(this.project));
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.p4ConfigId == null) {
            this.addErrorMessage("associate.perforce.config.id.required");
            return "error";
        }
        PerforceConfig config = this.perforceConfigStore.getConfig(this.p4ConfigId);
        if (config == null) {
            this.addErrorMessage("associate.perforce.config.not.extant");
            return "error";
        }
        this.clearConfig(this.project);
        this.perforceConfigStore.associateConfig(this.project, config);
        Collection<String> alwaysCreateJobsProjects = this.fisheyeProperties.getCollection("fisheye.p4.always.create.jobs");
        if (!this.alwaysCreateJobs) {
            alwaysCreateJobsProjects.remove(this.projectKey);
        } else if (!alwaysCreateJobsProjects.contains(this.projectKey)) {
            alwaysCreateJobsProjects.add(this.projectKey);
        }
        this.fisheyeProperties.setCollection("fisheye.p4.always.create.jobs", alwaysCreateJobsProjects);
        return this.getRedirect("/secure/project/ViewProject.jspa?pid=" + this.project.getId());
    }

    private void clearConfig(Project project) {
        PerforceConfig config = this.perforceConfigStore.getConfig(project);
        if (config != null) {
            this.perforceConfigStore.disassociateConfig(project, config);
        }
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public Integer getP4ConfigId() {
        return this.p4ConfigId;
    }

    public void setP4ConfigId(Integer p4ConfigId) {
        this.p4ConfigId = p4ConfigId;
    }

    public Project getProject() {
        return this.project;
    }

    public PerforceConfig getDefaultConfig() {
        return this.perforceConfigStore.getDefaultConfig();
    }

    public List getNonDefaultConfigs() {
        List<PerforceConfig> configs = this.perforceConfigStore.getAllConfigs();
        configs.remove(this.perforceConfigStore.getDefaultConfig());
        return configs;
    }

    public Integer getOldId() {
        return this.oldId;
    }

    public boolean isAlwaysCreateJobs() {
        return this.alwaysCreateJobs;
    }

    public void setAlwaysCreateJobs(boolean alwaysCreateJobs) {
        this.alwaysCreateJobs = alwaysCreateJobs;
    }
}

