/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.web.admin.fields.AbstractTextConfigField;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConfigField
extends AbstractTextConfigField {
    private static Logger log = LoggerFactory.getLogger(UrlConfigField.class);
    private final Set<String> existingUrls = new HashSet<String>();
    private boolean required;

    protected UrlConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection, boolean required) {
        super(key, value, isGlobal, i18n, errorCollection);
        this.required = required;
    }

    protected UrlConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection, boolean required, boolean requiresReconnect) {
        super(key, value, isGlobal, i18n, errorCollection, requiresReconnect);
        this.required = required;
    }

    protected UrlConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection, boolean required, boolean requiresReconnect, Collection<String> existingUrls) {
        super(key, value, isGlobal, i18n, errorCollection, requiresReconnect);
        this.required = required;
        this.existingUrls.addAll(existingUrls);
    }

    @Override
    public void validate() {
        String url = this.getValue();
        if (!TextUtils.stringSet((String)url)) {
            if (this.required) {
                this.addError(this.getKey(), this.getText("fisheye.config.error.url"));
            }
            return;
        }
        if (!this.hasProtocolSpecified(url)) {
            this.addError(this.getKey(), this.getText("fisheye.config.error.url.missing.protocol"));
        }
        try {
            new GetMethod(url);
        }
        catch (Exception e) {
            log.error("Can't save malformed FishEye url '" + url + "'", (Throwable)e);
            this.addError(this.getKey(), this.getText("fisheye.config.error.malformed.url"));
        }
        if (this.existingUrls.contains(url)) {
            this.addError(this.getKey(), this.getText("fisheye.config.error.url.already.configured", url));
        }
    }

    @Override
    public void normalise() {
        String url = this.getValue();
        if (TextUtils.stringSet((String)url) && !url.endsWith("/")) {
            this.setValue(url + "/");
        }
    }

    private boolean hasProtocolSpecified(String url) {
        return url.startsWith("http:") || url.startsWith("https:");
    }
}

