/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.web.admin.fields.AbstractStringConfigField;

public class PositiveIntConfigField
extends AbstractStringConfigField {
    protected PositiveIntConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection) {
        super(key, value, isGlobal, i18n, errorCollection);
    }

    @Override
    public void validate() {
        int value;
        String strValue = this.getValue();
        if (strValue == null || strValue.trim().length() < 1) {
            return;
        }
        String trimmedFormValue = strValue.trim();
        try {
            value = Integer.parseInt(trimmedFormValue);
        }
        catch (NumberFormatException ignore) {
            this.addError(this.getKey(), this.getText("fisheye.error.invalid.number"));
            return;
        }
        if (value < 0) {
            this.addError(this.getKey(), this.getText("fisheye.error.negative.number"));
            return;
        }
    }
}

