/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.util.ResourceUtil;
import com.atlassian.jirafisheyeplugin.web.admin.fields.AbstractTextConfigField;
import com.opensymphony.util.TextUtils;
import java.io.File;

public class FileOrClasspathResourceConfigField
extends AbstractTextConfigField {
    protected FileOrClasspathResourceConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection) {
        super(key, value, isGlobal, i18n, errorCollection);
    }

    @Override
    public void validate() {
        String file = this.getValue();
        if (!TextUtils.stringSet((String)file)) {
            return;
        }
        boolean isOnClasspath = ResourceUtil.getResourceAsStream(file, this.getClass()) != null;
        boolean isOnFileSystem = new File(file).exists();
        if (!isOnClasspath && !isOnFileSystem) {
            this.addError(this.getKey(), this.getText("fisheye.error.file.or.resource.not.found"));
        }
    }
}

