/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.web.admin.fields.AbstractTextConfigField;
import com.opensymphony.util.TextUtils;
import java.io.File;

public class FileConfigField
extends AbstractTextConfigField {
    private boolean required;
    private String missingErrorKey;

    protected FileConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection, boolean required, String missingErrorKey) {
        super(key, value, isGlobal, i18n, errorCollection);
        this.required = required;
        this.missingErrorKey = missingErrorKey;
    }

    protected FileConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection) {
        super(key, value, isGlobal, i18n, errorCollection);
        this.required = false;
    }

    @Override
    public void validate() {
        String file = this.getValue();
        if (!TextUtils.stringSet((String)file)) {
            if (this.required) {
                this.addError(this.getKey(), this.getText(this.missingErrorKey));
            }
            return;
        }
        boolean isOnFileSystem = new File(file).exists();
        if (!isOnFileSystem) {
            this.addError(this.getKey(), this.getText("fisheye.error.file.not.found"));
        }
    }
}

