/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigField;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigFieldStore;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class ConfigFieldStoreImpl
implements ConfigFieldStore {
    private FishEyeProperties properties;

    public ConfigFieldStoreImpl(FishEyeProperties properties) {
        this.properties = properties;
    }

    @Override
    public void store(ConfigField configField, ApplicationLink id) {
        if (configField != null && configField.shouldStore()) {
            if (TextUtils.stringSet((String)configField.getValue())) {
                configField.store(this.properties, id);
            } else {
                configField.remove(this.properties, id);
            }
        }
    }

    @Override
    public void storeAll(Collection<ConfigField> configFields, ApplicationLink applicationLink) {
        for (ConfigField configField : configFields) {
            this.store(configField, applicationLink);
        }
    }

    @Override
    public boolean isUpdated(ConfigField configField, ApplicationLink applicationLink) {
        String value = configField.retrieve(this.properties, applicationLink);
        if (!TextUtils.stringSet((String)value) && !TextUtils.stringSet((String)configField.getValue())) {
            return false;
        }
        return !configField.getValue().equals(value);
    }
}

