/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin.fields;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigField;

public abstract class AbstractConfigField
implements ConfigField {
    private String key;
    private String value;
    private I18nHelper i18n;
    private ErrorCollection errorCollection;
    private boolean isGlobal;

    protected AbstractConfigField(String key, String value, boolean isGlobal, I18nHelper i18n, ErrorCollection errorCollection) {
        this.key = key;
        this.value = value;
        this.isGlobal = isGlobal;
        this.i18n = i18n;
        this.errorCollection = errorCollection;
        this.normalise();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected void addError(String key, String err) {
        this.errorCollection.addError(key, err);
    }

    protected String getText(String key) {
        return this.i18n.getText(key);
    }

    protected String getText(String key, String p0) {
        return this.i18n.getText(key, p0);
    }

    @Override
    public void validate() {
    }

    @Override
    public void normalise() {
    }

    @Override
    public boolean shouldStore() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfigField that = (AbstractConfigField)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.i18n != null ? this.i18n.hashCode() : 0);
        result = 31 * result + (this.errorCollection != null ? this.errorCollection.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.key;
    }
}

