/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jirafisheyeplugin.config.properties.ApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.ual.UalUtil;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.ual.FishEyePropertyEnumerator;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ViewStoredPropertiesAction
extends BaseAdminAction {
    private final ApplicationLinkService applicationLinkService;
    private final ApplicationLinkIdMapper applicationLinkIdMapper;
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private ListMultimap<ApplicationLink, String> applicationPropertiesMap = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<String>>(){

        public List<String> get() {
            return Lists.newArrayList();
        }
    });

    public ViewStoredPropertiesAction(JiraAuthenticationContext authenticationContext, ApplicationLinkService applicationLinkService, FishEyePropertyEnumerator fishEyePropertyEnumerator, ApplicationLinkIdMapper applicationLinkIdMapper, FishEyeProperties fisheyeProperties, FishEyeInstanceStore fishEyeInstanceStore, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.applicationLinkService = applicationLinkService;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
        this.fishEyeInstanceStore = fishEyeInstanceStore;
    }

    public String doDefault() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        return "success";
    }

    protected String doExecute() throws Exception {
        return this.doDefault();
    }

    private <T> T renderProperty(FishEyeInstance fisheyeInstance, ApplicationLinkProperty<T> property) {
        T propertyValue = property.get(UalUtil.idToLink(this.applicationLinkService, fisheyeInstance.getApplicationId()));
        return (T)(property.getKey().equals("fisheye.password") && propertyValue != null ? "*****" : propertyValue);
    }

    public Map<ApplicationLink, Collection<String>> getApplicationPropertiesMap() {
        return this.applicationPropertiesMap.asMap();
    }

    private FishEyeInstance getFisheyeInstanceFor(ApplicationLink applicationLink) {
        return this.fishEyeInstanceStore.getFishEyeInstance(this.applicationLinkIdMapper.fromApplicationId(applicationLink.getId()));
    }
}

