/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.config.ual.UalUtil;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalFullMigrator;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgrader;
import com.atlassian.jirafisheyeplugin.web.admin.BaseFishEyeConfigurationAction;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigField;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigFieldFactory;
import com.atlassian.jirafisheyeplugin.web.admin.fields.ConfigFieldStore;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditFishEyeConfiguration
extends BaseFishEyeConfigurationAction {
    private static Logger log = LoggerFactory.getLogger(EditFishEyeConfiguration.class);
    private Collection<ConfigField> defaultConfigFields = Sets.newHashSet();
    private boolean submitted = false;
    private final ConfigFieldStore configFieldStore;
    private final ApplicationLinkService applicationLinkService;

    public EditFishEyeConfiguration(FishEyeManager fishEyeManager, FishEyeProperties fishEyeProperties, PermissionManager permissionManager, ProjectManager projectManager, ConfigFieldStore configFieldStore, FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore, CrucibleProjectStore crucibleProjectStore, RepositoryPathStore repositoryPathStore, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, UalUpgrader ualUpgrader, EventPublisher eventPublisher, RefreshManager refreshManager, ApplicationLinkService applicationLinkService, FishEyeConfig fishEyeConfig, UalFullMigrator ualFullMigrator, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(fishEyeProperties, permissionManager, projectManager, instanceStore, repositoryStore, crucibleProjectStore, repositoryPathStore, authenticationContext, fishEyeManager, velocityRequestContextFactory, ualUpgrader, eventPublisher, refreshManager, fishEyeConfig, ualFullMigrator, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        this.configFieldStore = configFieldStore;
        this.applicationLinkService = applicationLinkService;
    }

    public void doValidation() {
        for (ConfigField configField : this.defaultConfigFields) {
            configField.validate();
        }
        super.doValidation();
    }

    @Override
    public String doDefault() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        this.loadProperties();
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        if (!this.isSubmitted()) {
            this.loadProperties();
            return "input";
        }
        ApplicationLink applicationLink = null;
        if (this.isUseApplicationLink()) {
            try {
                applicationLink = this.getApplicationLink();
            }
            catch (IllegalArgumentException e) {
                log.debug("applicationLinkId is invalid:" + this.applicationLinkId);
                return "error";
            }
        }
        boolean hasUpdate = false;
        Iterator<ConfigField> iterator = this.defaultConfigFields.iterator();
        while (iterator.hasNext()) {
            ConfigField configField = iterator.next();
            if (this.configFieldStore.isUpdated(configField, applicationLink)) {
                hasUpdate = true;
                continue;
            }
            iterator.remove();
        }
        this.configFieldStore.storeAll(this.defaultConfigFields, applicationLink);
        if (hasUpdate) {
            this.refreshManager.refreshAll();
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("ViewFishEyeConfig.jspa");
    }

    protected boolean isUseApplicationLink() {
        return true;
    }

    protected ApplicationLink getApplicationLink() {
        return UalUtil.idToLink(this.applicationLinkService, new ApplicationId(this.applicationLinkId));
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public void setMaxChangesetsIssue(String maxChangesetsIssue) {
        this.maxChangesetsIssue = maxChangesetsIssue;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.display.issue.maxchangesets", maxChangesetsIssue, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setMaxChangesetsProject(String maxChangesetsProject) {
        this.maxChangesetsProject = maxChangesetsProject;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.display.project.maxchangesets", maxChangesetsProject, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setMaxPreviousDaysSearch(String maxPreviousDaysSearch) {
        this.maxPreviousDaysSearch = maxPreviousDaysSearch;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.max.previous.days.search", maxPreviousDaysSearch, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setMaxCruDaysSearch(String maxCruDaysSearch) {
        this.maxCruDaysSearch = maxCruDaysSearch;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.crucible.max.days.search", maxCruDaysSearch, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setCruSearchMethod(String cruSearchMethod) {
        this.cruSearchMethod = cruSearchMethod;
        this.defaultConfigFields.add(ConfigFieldFactory.string("fisheye.crucible.search.method", cruSearchMethod, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setMaxRevisions(String maxRevisions) {
        this.maxRevisions = maxRevisions;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.display.maxrevisions", maxRevisions, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setWikiRendering(String wikiRendering) {
        this.wikiRendering = wikiRendering;
        this.defaultConfigFields.add(ConfigFieldFactory.bool("fisheye.display.wiki.render", wikiRendering, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setSearchForMovedIssues(String searchForMovedIssues) {
        this.searchForMovedIssues = searchForMovedIssues;
        this.defaultConfigFields.add(ConfigFieldFactory.bool("fisheye.search.moved.issues", searchForMovedIssues, true, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setApiTimeout(String apiTimeout) {
        this.apiTimeout = apiTimeout;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.api.connection.timeout", apiTimeout, false, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setCharset(String charset) {
        this.charset = charset;
        this.defaultConfigFields.add(ConfigFieldFactory.string("fisheye.charset", charset, false, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setRevisionCacheSize(String revisionCacheSize) {
        this.revisionCacheSize = revisionCacheSize;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.revcache.size", revisionCacheSize, false, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.defaultConfigFields.add(ConfigFieldFactory.positiveInt("fisheye.api.socket.timeout", socketTimeout, false, (I18nHelper)this, (ErrorCollection)this));
    }

    public void setCrucibleEnabled(String crucibleEnabled) {
        this.crucibleEnabled = crucibleEnabled;
        this.defaultConfigFields.add(ConfigFieldFactory.cru("fisheye.crucible.enabled", crucibleEnabled, false, (I18nHelper)this, (ErrorCollection)this));
    }
}

