/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStoreImpl;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.crucible.CrucibleProjectUtils;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.OAuthErrorReport;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalFullMigrator;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgrader;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeFinishedEvent;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeStartedEvent;
import com.atlassian.jirafisheyeplugin.web.admin.BaseAdminAction;
import com.atlassian.jirafisheyeplugin.web.errorbeans.OAuthErrorBean;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFishEyeConfigurationAction
extends BaseAdminAction
implements FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(BaseFishEyeConfigurationAction.class);
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected final String PRETTY_CRU_SEARCH_METHOD_TEXT_ONLY = this.getText("fisheye.crucible.search.method.text.only");
    protected final String PRETTY_CRU_SEARCH_METHOD_REVISION_ONLY = this.getText("fisheye.crucible.search.method.revision.only");
    protected final String PRETTY_CRU_SEARCH_METHOD_TEXT_AND_REVISION = this.getText("fisheye.crucible.search.method.text.and.revision.view");
    protected final String PRETTY_CRU_SEARCH_METHOD_TEXT_STANDALONE = this.getText("fisheye.crucible.search.method.text.standalone.view");
    protected String applicationLinkId;
    protected String url;
    protected String apiUrl;
    protected String apiTimeout;
    protected String socketTimeout;
    protected String charset;
    protected String revisionCacheSize;
    protected String maxChangesetsProject;
    protected String maxPreviousDaysSearch;
    protected String maxChangesetsIssue;
    protected String maxRevisions;
    protected String maxCruDaysSearch;
    protected String cruSearchMethod;
    protected String crucibleEnabled;
    protected String wikiRendering;
    protected String searchForMovedIssues;
    private boolean oauth = false;
    private List<OAuthErrorBean> oauthErrors = Lists.newArrayList();
    private boolean testP4 = false;
    private String testP4Error = null;
    private String testP4Suggestion = null;
    private Map<String, String> lastUpdated;
    private RefreshCacheType refreshCache;
    private Multimap<String, String> refreshCacheErrors = Multimaps.newMultimap(new HashMap(), (Supplier)new Supplier<Collection<String>>(){

        public Collection<String> get() {
            return Lists.newArrayList();
        }
    });
    protected final FishEyeProperties fisheyeProperties;
    protected final FishEyeInstanceStore instanceStore;
    protected final FishEyeRepositoryStore repositoryStore;
    protected final CrucibleProjectStore crucibleProjectStore;
    protected final RepositoryPathStore repositoryPathStore;
    protected final ProjectManager projectManager;
    protected final VelocityRequestContextFactory velocityRequestContextFactory;
    protected final FishEyeConfig fishEyeConfig;
    protected final FishEyeManager fishEyeManager;
    protected final RefreshManager refreshManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFishEyeConfigurationAction(FishEyeProperties fisheyeProperties, PermissionManager permissionManager, ProjectManager projectManager, FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore, CrucibleProjectStore crucibleProjectStore, RepositoryPathStore repositoryPathStore, JiraAuthenticationContext authenticationContext, FishEyeManager fishEyeManager, VelocityRequestContextFactory velocityRequestContextFactory, UalUpgrader ualUpgrader, EventPublisher eventPublisher, RefreshManager refreshManager, FishEyeConfig fishEyeConfig, UalFullMigrator ualFullMigrator, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedSoftwareRenderer);
        String refresh;
        this.fishEyeManager = fishEyeManager;
        this.fisheyeProperties = fisheyeProperties;
        this.projectManager = projectManager;
        this.instanceStore = instanceStore;
        this.repositoryStore = repositoryStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.repositoryPathStore = repositoryPathStore;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.refreshManager = refreshManager;
        this.fishEyeConfig = fishEyeConfig;
        if (this.request != null && Boolean.valueOf(refresh = this.request.getParameter("refresh")).booleanValue()) {
            log.debug("Performing refresh...");
            this.refreshManager.refreshAll();
            log.debug("Performing Application Link sync...");
            eventPublisher.publish((Object)new UpgradeStartedEvent());
            try {
                ualFullMigrator.cleanOutOfSyncLinks();
                ualUpgrader.performUpgrade();
                ualFullMigrator.migrate();
            }
            catch (FishEyeUpgradeException e) {
                log.error("Error encountered while refreshing properties:", (Throwable)e);
            }
            finally {
                eventPublisher.publish((Object)new UpgradeFinishedEvent());
                log.debug("Application Link sync completed...");
            }
            try {
                this.refreshRepositoryList();
            }
            catch (OAuthNotAuthorisedException e) {
                this.oauth = true;
            }
            try {
                this.refreshProjectList();
            }
            catch (OAuthNotAuthorisedException e) {
                this.oauth = true;
            }
        }
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }

    protected String doExecute() throws Exception {
        Optional<String> permissionError = this.isActionAllowed(Optional.empty());
        if (permissionError.isPresent()) {
            return permissionError.get();
        }
        this.tryRefreshCaches();
        return "success";
    }

    private void tryRefreshCaches() {
        try {
            if (this.refreshCache == RefreshCacheType.Project) {
                this.refreshProjectList();
            } else if (this.refreshCache == RefreshCacheType.Repository) {
                this.refreshRepositoryList();
            }
        }
        catch (OAuthNotAuthorisedException ignored) {
            this.oauth = true;
        }
        if (this.oauth) {
            HashMap oauthExceptions = Maps.newHashMap();
            for (FishEyeInstance fishEyeInstance : this.instanceStore.getAllFishEyeInstances()) {
                try {
                    try {
                        this.fishEyeManager.getRepositories(fishEyeInstance);
                    }
                    catch (OAuthNotAuthorisedException e) {
                        oauthExceptions.put(fishEyeInstance, e);
                    }
                    try {
                        this.fishEyeManager.getProjects(fishEyeInstance);
                    }
                    catch (OAuthNotAuthorisedException e) {
                        oauthExceptions.put(fishEyeInstance, e);
                    }
                }
                catch (IOException ioe) {
                    log.debug("IOException [" + ioe + "] ignored.");
                }
            }
            URI callback = URI.create(this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl() + "/secure/admin/ViewFishEyeConfig.jspa");
            for (Map.Entry oauthError : oauthExceptions.entrySet()) {
                OAuthNotAuthorisedException oauthException = (OAuthNotAuthorisedException)oauthError.getValue();
                OAuthErrorReport oAuthErrorReport = new OAuthErrorReport((FishEyeInstance)oauthError.getKey(), (AuthorisationURIGenerator)oauthException, oauthException.getMessage());
                ArrayList errorReports = Lists.newArrayList((Object[])new OAuthErrorReport[]{oAuthErrorReport});
                this.oauthErrors.add(new OAuthErrorBean(oauthException.getAuthorisationURI(callback), errorReports));
            }
        }
    }

    public Map<String, String> getCachedDataLastUpdated() {
        if (this.lastUpdated == null) {
            this.lastUpdated = EasyMap.build((Object)RefreshCacheType.Project.name(), (Object)(this.crucibleProjectStore.getCrucibleProjectKeysLastUpdated() == null ? this.getText("fisheye.not.updated.desc") : this.crucibleProjectStore.getCrucibleProjectKeysLastUpdated()), (Object)RefreshCacheType.Repository.name(), (Object)(this.repositoryStore.getRepoListLastUpdatedTime() == null ? this.getText("fisheye.not.updated.desc") : this.repositoryStore.getRepoListLastUpdatedTime()));
        }
        return this.lastUpdated;
    }

    public boolean isInstancesEditable() {
        return true;
    }

    public String getRepositoryPath(String projectKey) {
        RepositoryPath path = this.repositoryPathStore.getRepositoryPath(projectKey);
        return path == null ? null : path.getPath();
    }

    public List<FishEyeInstance> getFishEyeInstances() {
        return this.instanceStore.getAllFishEyeInstances();
    }

    public FishEyeInstance getPrimaryFisheyeInstance() {
        return this.instanceStore.getDefaultFishEyeInstance();
    }

    public Collection<FishEyeRepository> getRepositoriesForInstance(FishEyeInstance instance) {
        return this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId());
    }

    public Collection<String> getCrucibleProjectsForInstance(FishEyeInstance instance) {
        return this.crucibleProjectStore.getCrucibleProjectKeys(instance.getApplicationId());
    }

    public Collection<Long> getJiraProjectForCrucibleProject(FishEyeInstance instance, String crucibleProjectKey) {
        return this.crucibleProjectStore.getJiraProjectsMappedToCrucibleProject(crucibleProjectKey, instance.getApplicationId());
    }

    public String getApiTimeout() {
        return this.apiTimeout;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCrucibleEnabled() {
        return this.crucibleEnabled;
    }

    public String getWikiRendering() {
        return this.wikiRendering;
    }

    public String useWikiRendering() {
        return TRUE.equals(this.wikiRendering) ? "On" : "Off";
    }

    public String getSearchForMovedIssues() {
        return this.searchForMovedIssues;
    }

    public String searchForMovedIssues() {
        return TRUE.equals(this.searchForMovedIssues) ? "On" : "Off";
    }

    public String crucibleIntegrationSetting() {
        if (FishEyeInstanceStoreImpl.CrucibleEnabledState.STANDALONE.name().equals(this.crucibleEnabled)) {
            return "Standalone";
        }
        return FishEyeInstanceStoreImpl.CrucibleEnabledState.ENABLED.name().equals(this.crucibleEnabled) ? "Yes" : "No";
    }

    public String getMaxCruDaysSearch() {
        return this.maxCruDaysSearch;
    }

    public String getPrettyCruSearchMethod() {
        if (this.isCruStandalone()) {
            return this.PRETTY_CRU_SEARCH_METHOD_TEXT_STANDALONE;
        }
        if (this.isCruSearchTextOnly()) {
            return this.PRETTY_CRU_SEARCH_METHOD_TEXT_ONLY;
        }
        if (this.isCruSearchTextAndRevision()) {
            return this.PRETTY_CRU_SEARCH_METHOD_TEXT_AND_REVISION;
        }
        return this.PRETTY_CRU_SEARCH_METHOD_REVISION_ONLY;
    }

    public boolean isCruStandalone() {
        return FishEyeInstanceStoreImpl.CrucibleEnabledState.STANDALONE.name().equals(this.crucibleEnabled);
    }

    public boolean isCruEnabled() {
        return this.isCruStandalone() || FishEyeInstanceStoreImpl.CrucibleEnabledState.ENABLED.name().equals(this.crucibleEnabled);
    }

    public boolean isCruSearchRevisionOnly() {
        return "cru.search.revision.only".equals(this.cruSearchMethod);
    }

    public boolean isCruSearchTextOnly() {
        return "cru.search.text.only".equals(this.cruSearchMethod);
    }

    public boolean isCruSearchTextAndRevision() {
        return this.cruSearchMethod == null || "cru.search.text.and.revision".equals(this.cruSearchMethod);
    }

    public String getMaxChangesetsIssue() {
        return this.maxChangesetsIssue;
    }

    public String getMaxChangesetsProject() {
        return this.maxChangesetsProject;
    }

    public String getMaxPreviousDaysSearch() {
        return this.maxPreviousDaysSearch;
    }

    public String getMaxRevisions() {
        return this.maxRevisions;
    }

    public String getRevisionCacheSize() {
        return this.revisionCacheSize;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getProjectId(String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            return null;
        }
        return project.getId();
    }

    public String getProjectKey(Long projectId) {
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            return null;
        }
        return project.getKey();
    }

    public boolean isTestP4() {
        return this.testP4;
    }

    public void setTestP4(boolean testP4) {
        this.testP4 = testP4;
    }

    public String getTestP4Error() {
        return this.testP4Error;
    }

    public void setTestP4Error(String testP4Error) {
        this.testP4Error = testP4Error;
    }

    public String getTestP4Suggestion() {
        return this.testP4Suggestion;
    }

    public void setTestP4Suggestion(String testP4Suggestion) {
        this.testP4Suggestion = testP4Suggestion;
    }

    public Collection<FishEyeRepository> getDefaultRepositories() {
        return this.repositoryStore.getDefaultRepositories();
    }

    public void setApplicationLinkId(String applicationLinkId) {
        this.applicationLinkId = applicationLinkId;
    }

    public String getApplicationLinkId() {
        return this.applicationLinkId;
    }

    public List<OAuthErrorBean> getOauthErrors() {
        return this.oauthErrors;
    }

    public boolean isOauth() {
        return this.oauth;
    }

    public void setOauth(boolean oauth) {
        this.oauth = oauth;
    }

    protected void loadProperties() {
        FishEyeInstance fisheyeInstance = this.applicationLinkId != null ? this.instanceStore.getFishEyeInstance(new ApplicationId(this.applicationLinkId)) : this.getPrimaryFisheyeInstance();
        if (fisheyeInstance != null) {
            this.url = fisheyeInstance.getUrl();
            this.apiUrl = fisheyeInstance.getApiUrl();
            this.apiTimeout = String.valueOf(fisheyeInstance.getConnectionTimeout());
            this.socketTimeout = String.valueOf(fisheyeInstance.getSocketTimeout());
            String string = this.charset = fisheyeInstance.getCharset() == null ? "" : fisheyeInstance.getCharset().name();
            this.crucibleEnabled = fisheyeInstance.isCru() ? (fisheyeInstance.isCruStandalone() ? FishEyeInstanceStoreImpl.CrucibleEnabledState.STANDALONE.name() : FishEyeInstanceStoreImpl.CrucibleEnabledState.ENABLED.name()) : FishEyeInstanceStoreImpl.CrucibleEnabledState.DISABLED.name();
            this.revisionCacheSize = String.valueOf(this.fishEyeConfig.getRevisionCacheSize());
            this.maxChangesetsProject = String.valueOf(this.fishEyeConfig.getMaxProjectChangesets());
            this.maxPreviousDaysSearch = String.valueOf(this.fishEyeConfig.getMaxDaysPrevious());
            this.maxChangesetsIssue = String.valueOf(this.fishEyeConfig.getMaxIssueChangeSets());
            this.maxRevisions = String.valueOf(this.fishEyeConfig.getMaxRevisions());
            this.cruSearchMethod = this.fishEyeConfig.getCruSearchMethod();
            this.wikiRendering = this.fishEyeConfig.isWikiRenderingEnabled() ? TRUE : FALSE;
            this.searchForMovedIssues = this.fishEyeConfig.isSearchForMovedIssues() ? TRUE : FALSE;
            this.maxCruDaysSearch = String.valueOf(this.fishEyeConfig.getMaxCruDaysSearch());
        }
    }

    protected void refreshRepositoryList() throws OAuthNotAuthorisedException {
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            try {
                HashSet newRepositories = Sets.newHashSet(this.fishEyeManager.getRepositories(instance));
                Set<FishEyeRepository> existing = this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId());
                this.repositoryStore.deleteRepositoriesForInstance(instance);
                this.repositoryStore.addRepositories(newRepositories, instance.getApplicationId());
                for (FishEyeRepository existingRepository : existing) {
                    for (Long mappedProjectId : existingRepository.getMappedProjectIds()) {
                        if (!newRepositories.contains(existingRepository.getName())) continue;
                        this.repositoryStore.associateProjectWithRepository(mappedProjectId, existingRepository.getName(), instance.getApplicationId());
                    }
                }
            }
            catch (OAuthNotAuthorisedException oauth) {
                throw oauth;
            }
            catch (IOException e) {
                String errorMessage = "Could not get repositories for instance ";
                this.refreshCacheErrors.put((Object)RefreshCacheType.Repository.name(), (Object)("Could not get repositories for instance " + instance.getUrl() + " - " + e));
                log.warn("Could not get repositories for instance " + instance.toString(), (Throwable)e);
            }
        }
    }

    protected void refreshProjectList() throws OAuthNotAuthorisedException {
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            try {
                this.crucibleProjectStore.setCrucibleProjectKeys(CrucibleProjectUtils.projectsToKeys(this.fishEyeManager.getProjects(instance)), instance.getApplicationId());
            }
            catch (OAuthNotAuthorisedException oauth) {
                throw oauth;
            }
            catch (IOException e) {
                String errorMessage = "Could not get projects for instance ";
                this.refreshCacheErrors.put((Object)RefreshCacheType.Project.name(), (Object)("Could not get projects for instance " + instance.getUrl() + " - " + e));
                log.warn("Could not get projects for instance " + instance.toString(), (Throwable)e);
            }
        }
    }

    public void setRefreshCache(String refreshCache) {
        try {
            this.refreshCache = RefreshCacheType.valueOf(refreshCache);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Multimap<String, String> getRefreshCacheErrors() {
        return this.refreshCacheErrors;
    }

    private static enum RefreshCacheType {
        Project,
        Repository;

    }
}

