/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.web.JiraPluginWebActionSupport;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAdminAction
extends JiraPluginWebActionSupport {
    public static final String UNLICENSED = "unlicensed";
    public static final String SECURITY_BREACH = "securitybreach";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final PermissionManager permissionManager;
    protected final SoftwareLicenseVerifier softwareLicenseVerifier;
    protected final UnlicensedSoftwareRenderer unlicensedSoftwareRenderer;

    public BaseAdminAction(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedSoftwareRenderer) {
        super(authenticationContext);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.softwareLicenseVerifier = (SoftwareLicenseVerifier)Preconditions.checkNotNull((Object)softwareLicenseVerifier, (Object)"softwareLicenseVerifier");
        this.unlicensedSoftwareRenderer = unlicensedSoftwareRenderer;
    }

    protected Optional<String> isActionAllowed(Optional<Project> project) {
        if (!this.softwareLicenseVerifier.isAllowedForGlobalAdmins()) {
            this.log.trace("No software license detected, action not allowed");
            return Optional.of(UNLICENSED);
        }
        if (project.isPresent() && project.map(p -> !this.softwareLicenseVerifier.isAllowedForProjectAdmins((Project)p)).get().booleanValue()) {
            this.log.trace("Project " + project.get() + " is not a software project, or no active software license detected, action not allowed");
            return Optional.of(UNLICENSED);
        }
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.permissionManager.hasPermission(0, user) ? Optional.empty() : Optional.of(SECURITY_BREACH);
    }

    public String getUnlicensedScreenHtml() {
        return this.unlicensedSoftwareRenderer.render(Optional.empty());
    }
}

