/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web.admin;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.web.admin.BaseProjectAdminAction;
import com.atlassian.jirafisheyeplugin.web.renderer.UnlicensedSoftwareRenderer;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.ListOrderedMap;

public class AssociateProjectRepositoryPath
extends BaseProjectAdminAction {
    private static final String FROM_CONFIG_SCREEN = "cfg";
    private static final String FROM_PROJECT_SCREEN = "prj";
    private static final String FIELD_INSTANCE = "fld_instance";
    private static final String FIELD_REPOSITORY = "fld_repository";
    private static final String FIELD_PATH = "fld_path";
    private static final String PARAM_INSTANCE = "prj_instance";
    private static final String PARAM_REP_PREFIX = "prj_rep_";
    private static final String PARAM_PATH = "prj_path";
    protected PermissionManager permissionManager;
    protected ProjectManager projectManager;
    protected FishEyeInstanceStore instanceStore;
    protected FishEyeRepositoryStore repositoryStore;
    protected RepositoryPathStore repositoryPathStore;
    private String fromScreen;
    private boolean submitted = false;
    private Long projectId;
    protected Project project;
    protected RepositoryPath repositoryPath;

    public AssociateProjectRepositoryPath(PermissionManager permissionManager, ProjectManager projectManager, FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore, RepositoryPathStore repositoryPathStore, JiraAuthenticationContext authenticationContext, SoftwareLicenseVerifier softwareLicenseVerifier, UnlicensedSoftwareRenderer unlicensedProjectPageRenderer) {
        super(authenticationContext, permissionManager, softwareLicenseVerifier, unlicensedProjectPageRenderer);
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.instanceStore = instanceStore;
        this.repositoryStore = repositoryStore;
        this.repositoryPathStore = repositoryPathStore;
    }

    protected Optional<String> validateAndSetupAction() {
        Optional<Project> maybeProject = this.getProject();
        Optional<String> permissionError = this.isActionAllowed(maybeProject);
        if (permissionError.isPresent()) {
            return permissionError;
        }
        this.project = this.checkProject(maybeProject);
        this.repositoryPath = this.repositoryPathStore.getRepositoryPath(this.project.getKey());
        return Optional.empty();
    }

    protected Optional<Project> getProject() {
        return Optional.ofNullable(this.projectManager.getProjectObj(this.getProjectId()));
    }

    public String doDefault() throws Exception {
        return this.validateAndSetupAction().orElse("input");
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        return this.validateAndSetupAction().orElseGet(() -> {
            if (!this.isSubmitted()) {
                return "input";
            }
            String instanceId = this.request.getParameter(PARAM_INSTANCE);
            String repName = this.request.getParameter(PARAM_REP_PREFIX + instanceId);
            String path = this.request.getParameter(PARAM_PATH);
            FishEyeInstance instance = null;
            FishEyeRepository repository = null;
            if (instanceId == null) {
                this.addError(FIELD_INSTANCE, this.getText("associate.project.repository.error.no.url"));
            } else {
                ApplicationId applicationId = new ApplicationId(instanceId);
                instance = this.instanceStore.getFishEyeInstance(applicationId);
                if (instance == null) {
                    this.addError(FIELD_INSTANCE, this.getText("associate.project.repository.error.missing.instance"));
                }
                if (repName == null) {
                    this.addError(FIELD_REPOSITORY, this.getText("associate.project.repository.error.no.repository"));
                } else {
                    repository = this.repositoryStore.getRepository(repName, applicationId);
                    if (repository == null) {
                        this.addError(FIELD_REPOSITORY, this.getText("associate.project.repository.error.missing.repository"));
                    }
                }
            }
            if (!TextUtils.stringSet((String)path)) {
                path = "/";
            } else if (!this.validatePath(path)) {
                this.addError(FIELD_PATH, this.getText("associate.project.repository.error.invalid.path"));
            }
            path = this.normalisePath(path);
            if (this.hasAnyErrors()) {
                this.log.error("The following action errors were encountered: ");
                for (Map.Entry e : this.errorMap.entrySet()) {
                    this.log.error("\t" + e.getKey() + " : " + e.getValue());
                }
                this.log.error("For instanceId=" + instanceId + ", repName=" + repName + ", path=" + path);
                return "error";
            }
            RepositoryPath newRepPath = new RepositoryPath(repository, path);
            this.log.debug("Updating project repository path: " + this.project.getKey() + " -> " + newRepPath);
            this.repositoryPathStore.updateRepositoryPath(this.project.getKey(), newRepPath);
            this.repositoryPathStore.reloadRepositoryPaths();
            return this.getSuccessRedirect();
        });
    }

    protected Project checkProject(Optional<Project> maybeProject) {
        return maybeProject.orElseThrow(() -> new IllegalStateException("The project you are trying to associate does not exist!"));
    }

    protected String getSuccessRedirect() {
        if (FROM_PROJECT_SCREEN.equals(this.getFromScreen())) {
            return this.getRedirect("/secure/project/ViewProject.jspa?pid=" + this.getProjectId());
        }
        return this.getRedirect("ViewFishEyeConfig.jspa");
    }

    private String normalisePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private boolean validatePath(String path) {
        return true;
    }

    public Map<FishEyeInstance, Collection<FishEyeRepository>> getInstanceRepositoryMap() {
        ListOrderedMap instanceRepositoryMap = new ListOrderedMap();
        List<FishEyeInstance> instances = this.instanceStore.getAllFishEyeInstances();
        for (FishEyeInstance instance : instances) {
            instanceRepositoryMap.put(instance, this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId()));
        }
        return instanceRepositoryMap;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public String getFromScreen() {
        return this.fromScreen;
    }

    public void setFromScreen(String fromScreen) {
        this.fromScreen = fromScreen;
    }

    public RepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    protected String getProjectKey() {
        return this.getProject().map(p -> p.getKey()).orElse(null);
    }
}

