/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.web;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jirafisheyeplugin.config.PermissionChecker;
import com.atlassian.jirafisheyeplugin.config.accesscondition.AccessCondition;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.stash.StashCommitService;
import com.atlassian.jirafisheyeplugin.web.ShowPanelHelper;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowPanelHelperImpl
implements ShowPanelHelper {
    private static final Logger log = LoggerFactory.getLogger(ShowPanelHelper.class);
    private final PermissionChecker permissionChecker;
    private final Set<AccessCondition> accessConditions;
    private final StashCommitService stashCommitService;

    public ShowPanelHelperImpl(PermissionChecker permissionChecker, Set<AccessCondition> accessConditions, StashCommitService stashCommitService) {
        this.stashCommitService = (StashCommitService)Preconditions.checkNotNull((Object)stashCommitService, (Object)"stashCommitService");
        this.permissionChecker = (PermissionChecker)Preconditions.checkNotNull((Object)permissionChecker, (Object)"permissionChecker");
        this.accessConditions = (Set)Preconditions.checkNotNull(accessConditions, (Object)"accessConditions");
    }

    @Override
    public boolean showIssuePanel(Issue issue, ApplicationUser remoteUser, FishEyeManager fisheyeManager, FishEyeConfig fisheyeConfig, String projectKey, Boolean validConfig, ShowPanelHelper.PageType pageType) {
        if (this.anyAccessConditionDeniesAccess(remoteUser)) {
            return false;
        }
        if (validConfig.booleanValue()) {
            boolean hasPerms = this.permissionChecker.hasVersionControlPermissions(issue, remoteUser);
            log.debug("has perms to show CRU project panel = " + hasPerms);
            return hasPerms && this.isAssociatedWith(fisheyeManager, projectKey, pageType);
        }
        return false;
    }

    @Override
    public boolean showProjectPanel(BrowseContext context, Project project, FishEyeManager fisheyeManager, String projectKey, Boolean validConfig, ShowPanelHelper.PageType pageType) {
        ApplicationUser remoteUser = context.getUser();
        boolean hasPerms = this.permissionChecker.hasVersionControlPermissions(project, remoteUser);
        log.debug("has perms to show FE issue panel = " + hasPerms);
        if (this.anyAccessConditionDeniesAccess(remoteUser)) {
            return false;
        }
        if (validConfig.booleanValue()) {
            return hasPerms && this.isAssociatedWith(fisheyeManager, projectKey, pageType);
        }
        return hasPerms && pageType == ShowPanelHelper.PageType.ISSUE_TAB_FE && this.stashCommitService.isConfigured();
    }

    private boolean isAssociatedWith(FishEyeManager fisheyeManager, String projectKey, ShowPanelHelper.PageType pageType) {
        boolean isAssociated = false;
        switch (pageType) {
            case ISSUE_TAB_CRU: 
            case PROJECT_TAB_CRU: {
                isAssociated = fisheyeManager.isAssociatedWithCrucible(projectKey);
                log.debug("Project is associated with one or more CRU projects = " + isAssociated);
                break;
            }
            case ISSUE_TAB_FE: {
                isAssociated = this.stashCommitService.isConfigured() || fisheyeManager.isAssociatedWithFishEye(projectKey);
                break;
            }
            case PROJECT_TAB_FE: {
                isAssociated = fisheyeManager.isAssociatedWithFishEye(projectKey);
                log.debug("Project is associated with one or more FE repositories = " + isAssociated);
            }
        }
        return isAssociated;
    }

    private boolean anyAccessConditionDeniesAccess(ApplicationUser remoteUser) {
        User directoryUser = ApplicationUsers.toDirectoryUser((ApplicationUser)remoteUser);
        for (AccessCondition module : this.accessConditions) {
            if (!this.accessConditionDeniesAccess(module, directoryUser)) continue;
            return true;
        }
        return false;
    }

    private boolean accessConditionDeniesAccess(AccessCondition module, User remoteUser) {
        try {
            if (module.deniesAccess(remoteUser)) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Condition " + module + " threw an exception; skipping", (Throwable)e);
        }
        return false;
    }
}

