/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class Util {
    private static final Comparator<Locale> LocaleComparator = new Comparator<Locale>(){

        @Override
        public int compare(Locale o1, Locale o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };

    public static String formatDate(String pattern, Date date, Locale locale) {
        return new SimpleDateFormat(pattern, Util.ensureLocaleSupported(locale)).format(date);
    }

    private static Locale ensureLocaleSupported(Locale locale) {
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        Arrays.sort(availableLocales, LocaleComparator);
        if (Arrays.binarySearch(availableLocales, locale, LocaleComparator) == -1) {
            locale = Locale.US;
        }
        return locale;
    }

    public static String uncheckedUrlEncode(String issueKey) {
        try {
            return URLEncoder.encode(issueKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String utf8Encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not installed!?", e);
        }
    }

    public static String utf8Encode(URI uri) {
        return Util.utf8Encode(uri.toASCIIString());
    }
}

