/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.jirafisheyeplugin.util.FishEyeUrlBuilder;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Locale;
import org.apache.velocity.tools.generic.EscapeTool;

public class JiraFisheyeEscapeTools {
    private static final EscapeTool esc = new EscapeTool();
    private static final FishEyeUrlBuilder url = FishEyeUrlBuilder.INSTANCE;

    @HtmlSafe
    public String htmlEncode(Object s) {
        if (s == null) {
            return null;
        }
        return esc.html(s).replaceAll("'", "&#39;");
    }

    public static String prettyPrintNumber(int number, Locale locale) {
        if (number < 1000) {
            return String.valueOf(number);
        }
        if (number < 999900) {
            return String.format(locale, "%.1fk", (double)number / 1000.0);
        }
        return String.format(locale, "%.1fm", (double)number / 1000000.0);
    }

    public String encodeJs(String s) {
        return esc.javascript((Object)s);
    }

    public String encodeUrl(String url) {
        return esc.url((Object)url);
    }

    public FishEyeUrlBuilder getUrl() {
        return url;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object that) {
        return that instanceof JiraFisheyeEscapeTools;
    }
}

