/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.opensymphony.util.TextUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FishEyeUtil {
    public static final String PLUGIN_KEY = "com.atlassian.jirafisheyeplugin";
    public static final ProjectTypeKey SOFTWARE_TYPE = new ProjectTypeKey("software");
    private static final DateFormat EYEQL_WHERE_CLAUSE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
    private static String anyIssueRx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toEyeQLFormat(Date date) {
        DateFormat dateFormat = EYEQL_WHERE_CLAUSE_FORMAT;
        synchronized (dateFormat) {
            return EYEQL_WHERE_CLAUSE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date fromISO8601(String date) throws ParseException {
        DateFormat dateFormat = ISO_8601_FORMAT;
        synchronized (dateFormat) {
            return ISO_8601_FORMAT.parse(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISO8601(Date date) {
        DateFormat dateFormat = ISO_8601_FORMAT;
        synchronized (dateFormat) {
            return ISO_8601_FORMAT.format(date);
        }
    }

    public static String makeProjectKeyRegex(String projectKey) {
        return "(^|[^a-zA-Z0-9-])" + projectKey + "-[0-9]+($|[^a-zA-Z0-9-])";
    }

    public static String makeIssueKeyRegex(String issueKey) {
        return "(^|[^a-zA-Z0-9-])" + issueKey + "($|[^a-zA-Z0-9-])";
    }

    private static String anyIssueRx() {
        if (anyIssueRx == null) {
            anyIssueRx = FishEyeUtil.makeIssueKeyRegex(FishEyeUtil.getUniversalIssueKeyRx());
        }
        return anyIssueRx;
    }

    public static List<String> getIssueKeysFromString(String string) {
        Matcher m = Pattern.compile(FishEyeUtil.anyIssueRx(), 2).matcher(string);
        ArrayList<String> keys = new ArrayList<String>();
        while (m.find()) {
            keys.add(m.group(2));
        }
        return keys;
    }

    public static List<String> getIssueKeysFromString(String string, String projectKey) {
        List<String> keys = FishEyeUtil.getIssueKeysFromString(string);
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (key.startsWith(projectKey)) continue;
            iterator.remove();
        }
        return keys;
    }

    public static Set getUniqueIssueKeysFromString(String string) {
        return new HashSet<String>(FishEyeUtil.getIssueKeysFromString(string));
    }

    public static Set getUniqueIssueKeysFromString(String string, String projectKey) {
        return new HashSet<String>(FishEyeUtil.getIssueKeysFromString(string, projectKey));
    }

    public static String mostRecentIssueKey(String string) {
        String mostRecent = null;
        int max = 0;
        for (String s : FishEyeUtil.getUniqueIssueKeysFromString(string)) {
            int p = FishEyeUtil.numericPart(s);
            if (p <= max) continue;
            mostRecent = s;
            max = p;
        }
        return mostRecent;
    }

    public static int numericPart(String issueKey) {
        String numericPart = issueKey.substring(issueKey.lastIndexOf(45) + 1);
        return Integer.parseInt(numericPart);
    }

    private static String getUniversalIssueKeyRx() {
        String prjRx;
        ApplicationProperties appProps = ComponentAccessor.getApplicationProperties();
        if (appProps != null && TextUtils.stringSet((String)(prjRx = appProps.getDefaultBackedString("jira.projectkey.pattern")))) {
            return "(" + prjRx + "-[0-9]+)";
        }
        return "([a-zA-Z]{2,}-[0-9]+)";
    }

    public static boolean equivalentInstanceIds(Integer id0, Integer id1) {
        if (!(id0 != null && id0 != 0 || id1 != null && id1 != 0)) {
            return true;
        }
        if (id0 == null || id1 == null) {
            return false;
        }
        return id0.intValue() == id1.intValue();
    }

    static {
        ISO_8601_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        EYEQL_WHERE_CLAUSE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

