/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import javax.ws.rs.core.UriBuilder;

public class FishEyeUrlBuilder {
    public static final FishEyeUrlBuilder INSTANCE = new FishEyeUrlBuilder();

    public String getFileDiffUrl(String baseUrl, String repoName, Revision revision) {
        UriBuilder uriBuilder = this.createRepoUriBuilder(baseUrl, "viewrep/", repoName);
        uriBuilder.path("/" + revision.getPath());
        uriBuilder.queryParam("r1", new Object[]{revision.getAncestor() != null ? revision.getAncestor() : ""});
        uriBuilder.queryParam("r2", new Object[]{revision.getRev()});
        return uriBuilder.build(new Object[0]).toString();
    }

    public String getRepositoryUrl(String baseUrl, String repoName) {
        UriBuilder uriBuilder = this.createRepoUriBuilder(baseUrl, "viewrep/", repoName);
        return uriBuilder.build(new Object[0]).toString();
    }

    public String getRepositoryBranchUrl(String baseUrl, String repoName, String branchName) {
        UriBuilder uriBuilder = this.createRepoUriBuilder(baseUrl, "changelog/~br=" + branchName + "/", repoName);
        return uriBuilder.build(new Object[0]).toString();
    }

    public String getChangesetUrl(String baseUrl, String repoName, String changesetId) {
        UriBuilder uriBuilder = this.createRepoUriBuilder(baseUrl, "changelog/", repoName);
        uriBuilder.queryParam("cs", new Object[]{changesetId});
        return uriBuilder.build(new Object[0]).toString();
    }

    private UriBuilder createRepoUriBuilder(String baseUrl, String prefix, String repoName) {
        return UriBuilder.fromPath((String)(baseUrl + prefix + repoName));
    }
}

