/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.properties.IntegerApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.util.ConfigUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtilImpl
implements ConfigUtil {
    private static Logger log = LoggerFactory.getLogger(ConfigUtilImpl.class);
    private FishEyeProperties properties;

    public ConfigUtilImpl(FishEyeProperties properties) {
        this.properties = properties;
    }

    @Override
    public String resolveUrl(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    @Override
    public String resolveRpcUrl(String rpcUrl, String displayUrl) {
        if (rpcUrl == null) {
            if (displayUrl != null) {
                return displayUrl;
            }
        } else {
            return this.resolveUrl(rpcUrl);
        }
        return rpcUrl;
    }

    @Override
    public Charset resolveCharset(String name) {
        if (name != null) {
            if (Charset.isSupported(name)) {
                return Charset.forName(name);
            }
            log.error("Charset '" + name + "' is not supported. Using platform default.");
        }
        return null;
    }

    @Override
    public int retrieveValidatedInt(String key, int defaultValue) {
        return this.retrieveValidatedInt(key, Integer.MAX_VALUE, defaultValue);
    }

    @Override
    public int retrieveValidatedIntWithServerId(IntegerApplicationLinkProperty property, int defaultValue, ApplicationLink link) {
        return this.retrieveValidatedIntWithServerId(property, Integer.MAX_VALUE, defaultValue, link);
    }

    @Override
    public int retrieveValidatedInt(String key, int max, int defaultValue) {
        return this.validateLong(key, max, defaultValue, this.properties.getLong(key));
    }

    private int validateLong(String key, int max, int defaultValue, Long value) {
        return this.validateInt(key, max, defaultValue, value == null ? null : Integer.valueOf(value.intValue()));
    }

    @Override
    public int retrieveValidatedIntWithServerId(IntegerApplicationLinkProperty property, int max, int defaultValue, ApplicationLink link) {
        return this.validateInt(property.getKey(), max, defaultValue, property.get(link));
    }

    private int validateInt(String name, int max, int defaultValue, Integer value) {
        if (value == null) {
            return defaultValue;
        }
        if (value > max) {
            log.error("Maximum value for property '" + name + "' is '" + max + "'. Returning + '" + max + "'");
            return max;
        }
        if (value < 0) {
            log.error("Property '" + name + "' should not be negative. Found '" + value + "'");
            return defaultValue;
        }
        return value;
    }
}

