/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetHelper {
    private static final Logger log = LoggerFactory.getLogger(CharsetHelper.class);
    private final ApplicationProperties applicationProperties;

    public CharsetHelper(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Charset defaultCharset() {
        String encoding = this.applicationProperties.getEncoding();
        if (Charset.isSupported(encoding)) {
            return Charset.forName(encoding);
        }
        Charset defaultCharset = Charset.defaultCharset();
        log.warn("Configured character encoding '{}' is not supported on this JVM, falling back to {}", (Object)encoding, (Object)defaultCharset.name());
        return defaultCharset;
    }
}

