/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.util;

import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class AJSConglomerateCookie
implements Map<String, String> {
    private static String AJS_COOKIE_NAME = "AJS.conglomerate.cookie";
    private static Pattern AJS_COOKIE_KVP_PATTERN = Pattern.compile("([^|=]+)=([^|]+)");
    private final Map<String, String> cookieValues;

    public static AJSConglomerateCookie fromExecutingRequest() {
        HttpServletRequest req = ExecutingHttpRequest.get();
        if (req != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!AJS_COOKIE_NAME.equals(cookie.getName())) continue;
                return new AJSConglomerateCookie(cookie);
            }
        }
        return new AJSConglomerateCookie();
    }

    protected AJSConglomerateCookie(Cookie cookie) {
        Matcher kvpMatches = AJS_COOKIE_KVP_PATTERN.matcher(cookie.getValue());
        HashMap cookieValues = Maps.newHashMap();
        while (kvpMatches.find()) {
            cookieValues.put(kvpMatches.group(1), kvpMatches.group(2));
        }
        this.cookieValues = ImmutableMap.copyOf((Map)cookieValues);
    }

    protected AJSConglomerateCookie() {
        this.cookieValues = ImmutableMap.of();
    }

    @Override
    public int size() {
        return this.cookieValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cookieValues.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cookieValues.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cookieValues.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.cookieValues.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.cookieValues.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.cookieValues.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.cookieValues.putAll(m);
    }

    @Override
    public void clear() {
        this.cookieValues.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.cookieValues.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.cookieValues.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.cookieValues.entrySet();
    }
}

